% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_distribution.R
\name{pareto_distribution}
\alias{pareto_distribution}
\alias{pareto_pdf}
\alias{pareto_lpdf}
\alias{pareto_cdf}
\alias{pareto_lcdf}
\alias{pareto_quantile}
\title{Pareto Distribution Functions}
\usage{
pareto_distribution(scale = 1, shape = 1)

pareto_pdf(x, scale = 1, shape = 1)

pareto_lpdf(x, scale = 1, shape = 1)

pareto_cdf(x, scale = 1, shape = 1)

pareto_lcdf(x, scale = 1, shape = 1)

pareto_quantile(p, scale = 1, shape = 1)
}
\arguments{
\item{scale}{scale parameter (default is 1)}

\item{shape}{shape parameter (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Pareto distribution.
}
\examples{
# Pareto distribution with scale = 10, shape = 5
dist <- pareto_distribution(10, 5)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
pareto_pdf(1)
pareto_lpdf(1)
pareto_cdf(1)
pareto_lcdf(1)
pareto_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/pareto.html}{Boost Documentation} for more details on the mathematical background.
}
