## code to prepare `smk_crit` dataset goes here
#' Critical values of the F-test on the independent variables in the conditional ARDL model.
#'
#' This internal data contains critical values of the Find test of Sam et al (2018), for several
#' sample sizes and  lag orders. Applicable only for cases I, III, and V.
#' Critical values at significance levels 1\%, 2.5\%, 5\% and 10\%.
#'
#' @format {A data frame with 144 rows and 17 variables}
#' \describe{
#'   \item{case}{case related to intercept and trend specification. Only I, III or V}
#'   \item{prob}{significance levels. 0.01, 0.025, 0.05 or 0.10}
#'   \item{num}{sample size, 30 to 80 and beyond for asymptotic critical values}
#'   \item{I0_x}{right threshold for accepting the null of zero coefficients in the Find test. x: 1 to 7}
#'   \item{I1_x}{left threshold for rejecting the null of zero coefficients in the Find test. x: 1 to }
#' }
#'
smk_crit=data.frame(
case = rep(c(1,3,5),each=48),
prob=rep(rep(c(0.01,0.025,0.05,0.1),each=12),3),
num=rep(c(30,35,40,45,50,55,60,65,70,75,80,81),12),
I0_1=c(7.79,7.48,7.52,7.21,7.03,7.05,7.17,7.12,6.82,7.05,6.87,6.65,5.65,5.45,5.46,5.34,5.28,5.23,5.37,5.18,5.2,5.26,5.19,5.1,4.19,4.08,4.09,3.99,3.98,4.01,4.06,3.99,3.93,4,3.93,3.87,2.88,2.88,2.83,2.79,2.78,2.77,2.84,2.77,2.77,2.79,2.8,2.72,7.7,7.48,7.43,7.41,7.36,7.04,7.03,7.22,6.89,6.96,6.98,6.53,5.61,5.47,5.52,5.46,5.36,5.24,5.25,5.35,5.12,5.24,5.23,4.95,4.22,4.19,4.1,4.11,4.03,4.01,4,4.08,3.9,4.01,3.98,3.79,2.88,2.85,2.84,2.87,2.82,2.83,2.8,2.86,2.73,2.78,2.8,2.67,7.82,7.65,7.46,7.33,7.19,7.13,7.04,7.08,7.03,7.07,7.1,6.65,5.55,5.56,5.48,5.39,5.36,5.32,5.28,5.3,5.3,5.26,5.2,5.02,4.22,4.1,4.15,4.06,4.05,3.99,4.03,3.98,3.99,4.02,3.98,3.87,2.91,2.87,2.84,2.85,2.82,2.79,2.81,2.75,2.82,2.77,2.76,2.74),
I1_1=c(11.61,11.31,11.18,10.98,11.01,11,10.72,10.52,10.55,10.74,10.79,10,8.9,8.82,8.67,8.58,8.62,8.62,8.44,8.3,8.31,8.48,8.4,8.05,7.07,6.93,6.87,6.81,6.78,6.79,6.7,6.71,6.66,6.79,6.75,6.57,5.13,5.07,5.05,5.07,5.07,5.08,5.03,5.05,5,5.07,5,5,12.34,12.31,12.4,12.13,12.05,12.09,11.84,11.85,11.69,11.7,11.49,11.05,9.56,9.52,9.48,9.3,9.28,9.3,9.19,9.29,9.16,9.04,9.03,8.84,7.51,7.42,7.41,7.33,7.29,7.36,7.29,7.28,7.22,7.17,7.09,7.21,5.34,5.31,5.37,5.3,5.29,5.36,5.31,5.34,5.32,5.24,5.24,5.31,12.57,12.51,12.21,12.39,12.12,12.11,12.22,11.85,11.8,12.22,12.05,11.76,9.51,9.52,9.29,9.4,9.31,9.27,9.45,9.19,9.21,9.53,9.23,9.19,7.33,7.32,7.09,7.29,7.16,7.22,7.32,7.25,7.22,7.32,7.22,7.25,5.2,5.17,5.11,5.24,5.12,5.2,5.22,5.22,5.18,5.26,5.18,5.3),
I0_2=c(5.52,5.38,5.32,5.19,5.06,4.94,4.95,4.99,4.96,4.9,4.92,4.65,4.31,4.17,4.12,4.04,3.99,3.92,3.9,3.93,3.88,3.9,3.89,3.73,3.4,3.32,3.29,3.23,3.21,3.15,3.11,3.15,3.14,3.12,3.13,3.02,2.53,2.49,2.48,2.45,2.42,2.38,2.37,2.41,2.39,2.4,2.37,2.32,5.41,5.35,5.14,5.06,5.14,5.05,5.03,4.99,4.97,4.9,4.98,4.71,4.25,4.12,4.04,3.99,4.04,3.95,3.94,3.9,3.96,3.88,3.87,3.74,3.36,3.31,3.26,3.21,3.22,3.13,3.15,3.14,3.14,3.12,3.12,3.01,2.53,2.48,2.45,2.41,2.4,2.38,2.41,2.42,2.38,2.37,2.36,2.31,5.46,5.33,5.25,5.14,5.12,5,5.16,5.06,4.89,4.92,4.9,4.58,4.22,4.18,4.05,4.03,4.03,3.96,3.98,4.03,3.84,3.92,3.84,3.67,3.35,3.3,3.22,3.24,3.2,3.2,3.17,3.23,3.1,3.13,3.12,3,2.53,2.49,2.44,2.42,2.45,2.41,2.41,2.44,2.39,2.39,2.36,2.3),
I1_2=c(8.45,8.04,8.08,7.86,7.96,7.73,7.64,7.64,7.49,7.53,7.54,7.13,6.77,6.58,6.52,6.43,6.4,6.25,6.27,6.27,6.19,6.21,6.28,5.99,5.59,5.47,5.38,5.35,5.31,5.26,5.26,5.25,5.24,5.19,5.23,5.05,4.42,4.32,4.28,4.28,4.22,4.22,4.21,4.22,4.21,4.16,4.18,4.09,9.16,8.75,8.58,8.38,8.24,8.31,8.1,8.24,8.09,8.08,8.02,7.68,7.24,6.96,6.94,6.78,6.74,6.76,6.67,6.72,6.65,6.67,6.65,6.42,5.9,5.64,5.68,5.62,5.62,5.54,5.56,5.59,5.54,5.5,5.54,5.42,4.54,4.43,4.46,4.43,4.44,4.37,4.4,4.37,4.43,4.34,4.36,4.33,9.05,8.92,8.82,8.79,8.62,8.43,8.31,8.28,8.38,8.28,8.3,7.94,7.12,7.05,7.02,6.86,6.84,6.8,6.74,6.74,6.82,6.74,6.76,6.53,5.77,5.72,5.66,5.62,5.54,5.55,5.59,5.55,5.58,5.62,5.57,5.45,4.43,4.41,4.37,4.32,4.33,4.32,4.36,4.35,4.36,4.39,4.35,4.34),
I0_3=c(4.59,4.53,4.38,4.38,4.26,4.23,4.13,4.07,4.11,4.06,3.98,3.75,3.67,3.57,3.5,3.49,3.4,3.38,3.32,3.32,3.33,3.31,3.24,3.12,3,2.92,2.86,2.85,2.81,2.76,2.73,2.74,2.73,2.73,2.71,2.61,2.32,2.28,2.24,2.21,2.21,2.19,2.17,2.17,2.15,2.16,2.16,2.09,4.6,4.51,4.35,4.34,4.29,4.18,4.24,4.12,4.13,4.13,4.09,3.83,3.64,3.59,3.49,3.46,3.45,3.37,3.38,3.31,3.35,3.3,3.31,3.15,2.96,2.93,2.85,2.81,2.83,2.79,2.78,2.74,2.75,2.74,2.73,2.62,2.3,2.3,2.23,2.2,2.23,2.2,2.19,2.15,2.17,2.16,2.16,2.08,4.67,4.54,4.42,4.34,4.27,4.13,4.13,4.14,4.08,4.06,4.02,3.86,3.17,3.58,3.57,3.48,3.42,3.38,3.36,3.34,3.28,3.31,3.26,3.17,2.97,2.93,2.9,2.84,2.82,2.79,2.77,2.76,2.74,2.73,2.7,2.64,2.3,2.27,2.25,2.23,2.21,2.21,2.19,2.2,2.16,2.16,2.12,2.11),
I1_3=c(7.21,7.02,6.78,6.61,6.72,6.5,6.47,6.4,6.45,6.42,6.23,5.93,5.93,5.75,5.7,5.55,5.53,5.47,5.4,5.42,5.38,5.41,5.27,5.05,4.96,4.84,4.84,4.7,4.68,4.68,4.62,4.63,4.61,4.61,4.55,4.41,3.99,3.96,3.92,3.87,3.83,3.88,3.82,3.82,3.82,3.8,3.77,3.69,7.72,7.23,7.24,7.06,7.07,6.89,6.83,6.76,6.79,6.79,6.71,6.33,6.22,6.04,5.92,4.34,5.87,5.74,5.75,5.63,5.64,5.6,5.6,5.4,5.14,5.05,4.97,4.94,4.94,4.92,4.88,4.85,4.8,4.79,4.77,4.65,4.11,4.04,4.03,3.97,3.99,4.02,3.99,3.94,3.91,3.94,3.93,3.86,7.58,7.59,7.32,7.17,6.98,7.04,6.99,6.86,6.7,6.83,6.77,6.46,6.16,6.1,5.98,5.85,5.76,5.82,5.76,5.73,5.72,5.76,5.66,5.45,5.09,5.05,4.96,4.92,4.86,4.85,4.82,4.82,4.82,4.86,4.8,4.7,4.04,3.99,3.96,3.93,3.94,3.94,3.91,3.92,3.94,3.96,3.94,3.89),
I0_4=c(4.13,4.04,3.94,3.84,3.8,3.7,3.71,3.67,3.6,3.63,3.56,3.37,3.34,3.27,3.2,3.13,3.1,3.02,3.03,3.02,2.99,2.98,2.94,2.82,2.75,2.71,2.65,2.61,2.57,2.54,2.53,2.51,2.51,2.5,2.49,2.39,2.18,2.15,2.12,2.09,2.07,2.03,2.04,2.03,2.04,2.03,2.02,1.95,4.15,4.03,3.9,3.8,3.69,3.75,3.68,3.68,3.6,3.66,3.61,3.33,3.36,3.26,3.18,3.11,3.04,3.05,3.01,3.05,2.98,3.02,2.98,2.79,2.8,2.7,2.64,2.6,2.55,2.55,2.54,2.55,2.51,2.54,2.51,2.39,2.22,2.14,2.11,2.08,2.06,2.06,2.05,2.05,2.04,2.04,2.04,1.96,4.3,4.02,3.94,3.82,3.76,3.71,3.67,3.64,3.66,3.61,3.56,3.4,3.37,3.3,3.16,3.15,3.09,3.05,3.02,3.01,3.01,3,2.96,2.81,2.74,2.71,2.63,2.62,2.58,2.55,2.52,2.53,2.53,2.53,2.5,2.4,2.18,2.16,2.11,2.1,2.07,2.05,2.05,2.03,2.04,2.04,2.03,1.97),
I1_4=c(6.67,6.33,6.26,6.12,6,5.87,5.78,5.78,5.74,5.68,5.62,5.35,5.46,5.31,5.19,5.1,5.08,4.97,4.94,4.95,4.9,4.88,4.81,4.57,4.61,4.54,4.45,4.36,4.35,4.3,4.25,4.27,4.25,4.23,4.18,4.01,3.78,3.76,3.71,3.65,3.63,3.6,3.59,3.58,3.57,3.56,3.53,3.46,6.83,6.63,6.39,6.33,6.17,6.19,6.09,5.98,5.86,5.97,5.87,5.47,5.6,5.5,5.35,5.34,5.22,5.21,5.13,5.08,5.03,5.1,5,4.73,4.7,4.67,4.54,4.55,4.49,4.51,4.42,4.38,4.37,4.4,4.39,4.18,3.84,3.82,3.76,3.76,3.74,3.72,3.67,3.68,3.67,3.68,3.66,3.58,7.01,6.69,6.55,6.37,6.19,6.19,6.08,6.11,5.99,6,5.97,5.68,5.67,5.47,5.39,5.26,5.18,5.23,5.11,5.11,5.07,5.09,5.06,4.94,4.71,4.61,4.54,4.51,4.44,4.47,4.42,4.39,4.4,4.38,4.35,4.31,3.79,3.74,3.72,3.69,3.67,3.69,3.66,3.64,3.66,3.66,3.63,3.62),
I0_5=c(3.92,3.79,3.63,3.57,3.47,3.43,3.35,3.34,3.32,3.31,3.26,3.05,3.19,3.09,2.99,2.92,2.91,2.83,2.81,2.78,2.77,2.78,2.73,2.58,2.62,2.57,2.51,2.45,2.45,2.4,2.4,2.36,2.35,2.36,2.34,2.22,2.12,2.08,2.05,2,1.99,1.97,1.97,1.94,1.95,1.94,1.94,1.85,3.94,3.7,3.71,3.53,3.46,3.42,3.38,3.38,3.32,3.29,3.28,3.05,3.19,3.06,3,2.92,2.9,2.87,2.79,2.8,2.79,2.76,2.75,2.59,2.65,2.59,2.49,2.46,2.45,2.42,2.37,2.36,2.37,2.36,2.34,2.24,2.12,2.07,2.03,2,2,1.99,1.95,1.96,1.95,1.92,1.92,1.86,4,3.87,3.69,3.59,3.52,3.42,3.42,3.37,3.28,3.3,3.28,3.05,3.24,3.12,3.01,2.96,2.94,2.83,2.84,2.82,2.77,2.78,2.74,2.6,2.67,2.57,2.51,2.49,2.45,2.4,2.4,2.4,2.37,2.37,2.34,2.24,2.13,2.08,2.03,2.03,2,1.98,1.97,1.97,1.94,1.93,1.94,1.87),
I1_5=c(6.24,5.94,5.89,5.6,5.52,5.5,5.43,5.33,5.35,5.33,5.24,4.85,5.17,5.03,4.93,4.75,4.73,4.72,4.64,4.6,4.61,4.54,4.51,4.27,4.41,4.3,4.26,4.13,4.12,4.09,4.06,4.02,4.02,3.98,3.97,3.81,3.67,3.59,3.57,3.49,3.47,3.48,3.43,3.42,3.42,3.39,3.4,3.3,6.48,6.15,6.02,5.83,5.81,5.68,5.63,5.58,5.5,5.47,5.33,5.02,5.33,5.15,5.08,4.94,4.92,4.85,4.79,4.74,4.72,4.7,4.6,4.41,4.54,4.4,4.36,4.24,4.25,4.17,4.18,4.13,4.13,4.12,4.05,3.9,3.76,3.67,3.63,3.58,3.57,3.54,3.55,3.51,3.49,3.51,3.45,3.39,6.66,6.26,5.96,5.91,5.72,5.67,5.67,5.62,5.52,5.51,5.5,5.12,5.37,5.16,4.99,4.93,4.89,4.8,4.81,4.77,4.74,4.76,4.76,4.51,4.49,4.4,4.24,4.27,4.2,4.19,4.17,4.12,4.14,4.11,4.13,3.98,3.67,3.62,3.54,3.56,3.52,3.51,3.51,3.46,3.48,3.46,3.48,3.44),
I0_6=c(3.69,3.52,3.39,3.35,3.22,3.22,3.13,3.13,3.16,3.1,3.02,2.84,3.01,2.92,2.79,2.78,2.71,2.71,2.64,2.65,2.63,2.61,2.58,2.44,2.53,2.48,2.39,2.37,2.31,2.3,2.27,2.27,2.25,2.25,2.23,2.12,2.04,2.01,1.96,1.94,1.91,1.9,1.89,1.88,1.87,1.88,1.85,1.77,3.72,3.58,3.37,3.33,3.31,3.22,3.2,3.07,3.11,3.09,3.02,2.84,3.04,2.95,2.79,2.77,2.75,2.68,2.66,2.63,2.61,2.63,2.59,2.43,2.53,2.47,2.37,2.36,2.32,2.29,2.28,2.26,2.25,2.25,2.23,2.12,2.06,2,1.95,1.94,1.9,1.9,1.89,1.87,1.86,1.87,1.86,1.78,3.77,3.58,3.46,3.37,3.29,3.23,3.16,3.17,3.1,3.04,3,2.81,3.05,2.94,2.85,2.8,2.73,2.73,2.67,2.65,2.62,2.58,2.57,2.41,2.56,2.46,2.42,2.37,2.32,2.32,2.28,2.28,2.25,2.24,2.22,2.11,2.07,2,1.98,1.95,1.92,1.91,1.89,1.89,1.87,1.86,1.86,1.78),
I1_6=c(6.12,5.71,5.57,5.34,5.24,5.15,5.13,5.13,5.02,4.98,5.06,4.55,5.07,4.82,4.74,4.59,4.51,4.45,4.44,4.39,4.38,4.3,4.44,4,4.34,4.18,4.09,4.02,3.97,3.91,3.88,3.86,3.85,3.81,3.91,3.6,3.6,3.51,3.47,3.42,3.38,3.37,3.34,3.32,3.31,3.29,3.36,3.17,6.16,5.82,5.74,5.52,5.46,5.36,5.26,5.19,5.15,5.1,5.07,4.69,5.18,4.89,4.81,4.7,4.64,4.57,4.56,4.5,4.47,4.41,4.43,4.14,4.37,4.22,4.15,4.09,4.03,4.02,3.98,3.95,3.91,3.9,3.9,3.72,3.62,3.52,3.49,3.46,3.42,3.41,3.41,3.39,3.36,3.37,3.35,3.25,6.25,5.91,5.68,5.61,5.44,5.34,5.33,5.25,5.2,5.24,5.17,4.79,5.12,4.91,4.79,4.74,4.63,4.57,4.58,4.49,4.5,4.5,4.45,4.23,4.34,4.18,4.11,4.08,4.03,3.98,3.98,3.95,3.94,3.94,3.92,3.75,3.56,3.47,3.45,3.45,3.38,3.37,3.38,3.36,3.36,3.34,3.34,3.27),
I0_7=c(3.62,3.39,3.24,3.19,3.1,3.04,2.96,2.95,2.97,2.92,2.91,2.65,2.94,2.82,2.73,2.64,2.62,2.56,2.52,2.49,2.5,2.49,2.48,2.3,2.48,2.37,2.32,2.27,2.25,2.2,2.18,2.16,2.16,2.15,2.15,2.02,2.01,1.95,1.92,1.89,1.86,1.84,1.82,1.82,1.81,1.81,1.81,1.72,3.62,3.42,3.23,3.19,3.08,3.06,3.05,2.98,2.98,2.93,2.94,2.62,2.96,2.81,2.73,2.67,2.6,2.59,2.57,2.51,2.51,2.5,2.48,2.29,2.47,2.4,2.32,2.26,2.24,2.22,2.19,2.17,2.16,2.15,2.14,2.01,2.02,1.95,1.92,1.88,1.86,1.85,1.83,1.83,1.82,1.8,1.8,1.72,3.7,3.43,3.33,3.2,3.1,3.05,3.01,2.97,2.94,2.95,2.91,2.68,3.02,2.83,2.78,2.66,2.62,2.57,2.55,2.51,2.49,2.5,2.48,2.31,2.54,2.41,2.34,2.29,2.25,2.23,2.19,2.16,2.16,2.15,2.15,2.02,2.06,1.97,1.93,1.9,1.86,1.84,1.84,1.82,1.82,1.82,1.81,1.72),
I1_7=c(5.83,5.59,5.37,5.22,4.95,4.96,4.93,4.85,4.81,4.78,4.75,4.31,4.96,4.78,4.57,4.49,4.35,4.3,4.27,4.24,4.15,4.19,4.14,3.86,4.22,4.09,3.95,3.89,3.84,3.78,3.77,3.76,3.68,3.71,3.67,3.47,3.53,3.46,3.38,3.32,3.3,3.28,3.25,3.24,3.22,3.21,3.21,3.06,6.12,5.77,5.44,5.36,5.2,5.12,5.03,4.93,4.92,4.86,4.86,4.42,5.06,4.81,4.62,4.54,4.48,4.41,4.33,4.31,4.28,4.26,4.25,3.97,4.3,4.15,4.02,3.96,3.93,3.86,3.84,3.82,3.79,3.76,3.75,3.58,3.55,3.48,3.39,3.38,3.34,3.31,3.31,3.28,3.25,3.26,3.25,3.15,6,5.69,5.45,5.33,5.15,5.13,5.07,5.01,5.04,4.91,4.86,4.54,5.01,4.77,4.64,4.57,4.42,4.38,4.39,4.33,4.28,4.25,4.24,4.04,4.24,4.09,4,3.98,3.86,3.85,3.84,3.81,3.77,3.76,3.74,3.62,3.48,3.4,3.35,3.37,3.3,3.3,3.3,3.27,3.26,3.25,3.22,3.17))
use_data(smk_crit, overwrite = TRUE,internal=TRUE)
