% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credint.R
\name{credint}
\alias{credint}
\title{Posterior Credible Interval for Population Average Treatment Effect (PATE)}
\usage{
credint(object, level = 0.95)
}
\arguments{
\item{object}{An object of class pate fit by the \code{pate} function.}

\item{level}{the credible level required}
}
\description{
Computes an equal-tailed credible interval for an object of class 'pate'
}
\examples{
data(adapt)

est <- pate(y ~ treatment*x + treatment*I(x ^ 2), data = adapt,
 estimator = "bayesian_lm", src_var = "source", primary_source = "Primary",
 trt_var = "treatment")

credint(est)

}
