% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{sleep_int}
\alias{sleep_int}
\title{Sleep Interval Manual Override}
\usage{
sleep_int(data, sleep_start_end = NULL, adj = TRUE)
}
\arguments{
\item{data}{Supplied data from function}

\item{sleep_start_end}{User-supplied sleep interval to indicate start and end time of
the sleep interval of interest. Must only contain 2 values and must be 24-hour denoted integers}

\item{adj}{Logical indicating whether or not to perform necessary adjustments / additions to data
for WAKE column (i.e. set the default sleep time from 11PM - 6 AM if no interval specified and
a DATE_TIME column is available). Default set to TRUE. adj == FALSE essentially acts as a pass statement}
}
\value{
Dataframe with added / adjusted WAKE column moved after DATE_TIME column containing binary 1 (awake)
and 0 (asleep)
}
\description{
Adjusts WAKE column to reflect start and end of user-defined sleep period. If sleep_start_end
is NULL and WAKE column is included in input data, this function will not alter data.
}
