% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Motor}
\alias{Motor}
\title{Phase differences in hand flexion-extension movements.}
\format{
A data frame with 42 rows and 4 variables: \describe{ \item{Cond}{a
  factor variable indicating the condition a participant was placed in; 1 =
  'explicit', 2 = 'semi.implicit' or 3 = 'implicit'} \item{PhaseDiff}{a
  numeric variable the phase difference between 'observer' and 'mover' in
  degrees} \item{AvAmp}{a numeric variable indicating the average amplitude
  of the hand movement of the 'observer'} \item{Phaserad}{a numeric variable
  the phase difference between 'observer' and 'mover' in radians} }
}
\source{
\doi{10.1371/journal.pone.0177457}
}
\usage{
Motor
}
\description{
A dataset from a study by Puglisi et.al. (2017) on the role of attention in
human motor resonance.
}
\details{
In their research Puglisi et.al. (2017) conduct a between subjects experiment
in which `observers' in multiple degrees of explicitness are asked to look at
the movement of a hand of the `mover' or other object in order to evaluate
the role of attention in motor resonant response.

The experiment has four conditions:

1. The `explicit observation' condition (n = 14), where observers are
explicitly instructed to observe the hand.

2. The `semi-implicit observation' condition (n = 14) where the observers
have to do a task that requires implicit observation of the hand.

3. The `implicit observation' condition (n = 14), where observers have to do
a task that is independent of the observation of the hand that is moving in
front of them.

4. A baseline condition (n=14) where there is no moving hand but observers
have to look at an inanimate object that moves in an identical manner to the
hand.

The idea of motor resonance is then that the `observer', because they are
looking explicitly or implicitly at the hand of the `mover', starts moving
his or her hand in the same manner. This is the resonant response. In each
condition the hand movements of the observers were measured and the phase
difference between the observers' hand and the hand they observed (the
movers' hand) was calculated. This was not done for the baseline condition
because in this condition there was no periodic pattern of movement in the
`observers' hand.

The phase difference is a circular variable and can be described and analyzed
using circular statistics.
}
\keyword{datasets}
