#' @name  data25j3
#' @title Simulated data from the OR2 model for \eqn{p = 0.25} (i.e., 25th quantile)
#'
#' @details
#'
#' This data contains 500 observations generated from a quantile
#' ordinal model with 3 outcomes at the 25th quantile (i.e., \eqn{p = 0.25}).
#' The model specifics for generating the data are as follows: \eqn{\beta = (-4, 6, 5)}, X ~ Unif(0, 1), and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.25}). The cut-points \eqn{(0, 3)} are used to classify the
#' continuous values of the dependent variable into 3 categories, which form the ordinal outcomes.
#'
#' @docType data
#'
#' @usage data(data25j3)
#'
#' @return Returns a list with components
#' \item{\code{x}: }{a matrix of covariates, including a column of ones.}
#' \item{\code{y}: }{a column vector of ordinal outcomes.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#' Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
#' Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
#'
#' @keywords datasets
#'
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data50j3
#' @title Simulated data from the OR2 model for \eqn{p = 0.5} (i.e., 50th quantile)
#'
#' @details
#'
#' This data contains 500 observations generated from a quantile
#' ordinal model with 3 outcomes at the 50th quantile (i.e., \eqn{p = 0.5}).
#' The model specifics for generating the data are as follows: \eqn{\beta = (-4, 6, 5)}, X ~ Unif(0, 1), and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.5}). The cut-points \eqn{(0, 3)} are used to classify the
#' continuous values of the dependent variable into 3 categories, which form the ordinal outcomes.
#'
#' @docType data
#' @usage data(data50j3)
#'
#' @return Returns a list with components
#' \item{\code{x}: }{a matrix of covariates, including a column of ones.}
#' \item{\code{y}: }{a column vector of ordinal outcomes.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#' Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
#' Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
#'
#' @keywords datasets
#'
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data75j3
#' @title Simulated data from the OR2 model for \eqn{p = 0.75} (i.e., 75th quantile)
#'
#' @details
#'
#' This data contains 500 observations generated from a quantile
#' ordinal model with 3 outcomes at the 75th quantile (i.e., \eqn{p = 0.75}).
#' The model specifics for generating the data are as follows: \eqn{\beta = (-4, 6, 5)}, X ~ Unif(0, 1), and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.75}). The cut-points \eqn{(0, 3)} are used to classify the
#' continuous values of the dependent variable into 3 categories, which form the ordinal outcomes.
#'
#' @docType data
#' @usage data(data75j3)
#'
#' @return Returns a list with components
#' \item{\code{x}: }{a matrix of covariates, including a column of ones.}
#' \item{\code{y}: }{a column vector of ordinal outcomes.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#' Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
#' Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
#'
#' @keywords datasets
#'
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data25j4
#' @title Simulated data from the OR1 model for \eqn{p = 0.25} (i.e., 25th quantile)
#'
#' @details
#'
#' This data contains 500 observations generated from a quantile
#' ordinal model with 4 outcomes at the 25th quantile (i.e., \eqn{p = 0.25}).
#' The model specifics for generating the data are as follows: \eqn{\beta = (-4, 5, 6)}, X ~ Unif(0, 1), and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.25}). The cut-points \eqn{(0, 2, 4)} are used to classify the
#' continuous values of the dependent variable into 4 categories, which form the ordinal outcomes.
#'
#' @docType data
#' @usage data(data25j4)
#'
#' @return Returns a list with components
#' \item{\code{x}: }{a matrix of covariates, including a column of ones.}
#' \item{\code{y}: }{a column vector of ordinal outcomes.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#' Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
#' Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
#'
#' @keywords datasets
#'
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data50j4
#' @title Simulated data from the OR1 model for \eqn{p = 0.5} (i.e., 50th quantile)
#'
#' @details
#'
#' This data contains 500 observations generated from a quantile
#' ordinal model with 4 outcomes at the 50th quantile (i.e., \eqn{p = 0.5}).
#' The model specifics for generating the data are as follows: \eqn{\beta = (-4, 5, 6)}, X ~ Unif(0, 1), and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.5}). The cut-points \eqn{(0, 2, 4)} are used to classify the
#' continuous values of the dependent variable into 4 categories, which form the ordinal outcomes.
#'
#' @docType data
#' @usage data(data50j4)
#'
#' @return Returns a list with components
#' \item{\code{x}: }{a matrix of covariates, including a column of ones.}
#' \item{\code{y}: }{a column vector of ordinal outcomes.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#'  Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
#'  Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
#'
#' @keywords datasets
#'
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL

#' @name  data75j4
#' @title Simulated data from the OR1 model for \eqn{p = 0.75} (i.e., 75th quantile)
#'
#' @details
#'
#' This data contains 500 observations generated from a quantile
#' ordinal model with 4 outcomes at the 75th quantile (i.e., \eqn{p = 0.75}).
#' The model specifics for generating the data are as follows: \eqn{\beta = (-4, 5, 6)}, X ~ Unif(0, 1), and
#' \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.75}). The cut-points \eqn{(0, 2, 4)} are used to classify the
#' continuous values of the dependent variable into 4 categories, which form the ordinal outcomes.
#'
#' @docType data
#' @usage data(data75j4)
#'
#' @return Returns a list with components
#' \item{\code{x}: }{a matrix of covariates, including a column of ones.}
#' \item{\code{y}: }{a column vector of ordinal outcomes.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#' Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
#' Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
#'
#' @keywords datasets
#'
#' @seealso \link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
#'
NULL


#' @name  Educational_Attainment
#' @title Educational Attainment study based on data from the National Longitudinal Study of Youth (NLSY, 1979) survey.
#'
#' @details
#'
#' This data is taken from the National Longitudinal Study of Youth (NLSY, 1979)
#' survey and corresponds to 3,923 individuals. The objective is to study the
#' effect of family background, individual, and school level variables on the
#' quantiles of educational attainment conditional on the covariates. The dependent variable
#' i.e. the educational degree, has four categories given as less than high school, high school degree,
#' some college or associate's degree, and college or graduate degree. The independent
#' variables include intercept, square root of family income, mother's education,
#' father's education, mother's working status, gender, race, and whether the youth
#' lived in an urban area at the age of 14, and indicator variables to control for age-cohort
#' effects.
#'
#' @docType data
#'
#' @usage data(Educational_Attainment)
#'
#' @return Returns data with components
#' \item{\code{mother_work}: }{Indicator for working female at the age of 14.}
#' \item{\code{urban}: }{Indicator for the youth living in urban area at the age of 14.}
#' \item{\code{south}: }{Indicator for the youth living in South at the age of 14.}
#' \item{\code{father_educ}: }{Number of years of father's education.}
#' \item{\code{mother_educ}: }{Number of years of mother's education.}
#' \item{\code{fam_income}: }{Family income of the household in $1000.}
#' \item{\code{female}: }{Indicator for individual's gender.}
#' \item{\code{black}: }{Indicator for black race.}
#' \item{\code{age_cohort_2}: }{Indicator variable for age 15.}
#' \item{\code{age_cohort_3}: }{Indicator variable for age 16.}
#' \item{\code{age_cohort_4}: }{Indicator variable for age 17.}
#' \item{\code{dep_edu_level}: }{Four categories of educational attainment: less than high school, high school degree,
#' some college or associate's degree, and college or graduate degree.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#' Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). `"Fitting and Comparison of Models for Multivariate Ordinal Outcomes."`
#' Advances in Econometrics: Bayesian Econometrics, 23: 115`-`156. DOI: 10.1016/S0731-9053(08)23004-5
#'
#' Jeliazkov, I., and Rahman, M. A. (2012). `"Binary and Ordinal Data Analysis in Economics: Modeling and Estimation"`
#' in Mathematical Modeling with Multidisciplinary Applications, edited by X.S. Yang,
#' 123-150. John Wiley `&` Sons Inc, Hoboken, New Jersey. DOI: 10.1002/9781118462706.ch6
#'
#' @keywords datasets
#'
#' @seealso \href{https://www.bls.gov/nls/nlsy97.htm}{Survey Process}.
#'
NULL

#' @name  Policy_Opinion
#' @title Data contains public opinion on the proposal to raise federal income taxes for couples (individuals) earning more than $250,000 ($200,000) per year and a host of other covariates. The data is taken from the 2010-2012 American National Election Studies (ANES) on the Evaluation of Government and Society Study I (EGSS 1)
#'
#' @details
#'
#' The data consists of 1,164 observations taken from the 2010-2012 American National Election
#' Studies (ANES) on the Evaluations of Government and Society Study 1 (EGSS 1). The objective
#' is to analyze public opinion on the proposal to raise federal income taxes for couples (individuals)
#' earning more than $250,000 ($200,000) per year. The responses were recorded as oppose, neither
#' favor nor oppose, or favor the tax increase, and forms the dependent variable in the study. The
#' independent variables include indicator variables (or dummy) for employment, income above
#' $75,000, bachelor's and post-bachelor's degree, computer ownership, cellphone ownership, and white race.
#'
#' @docType data
#'
#' @usage data(Policy_Opinion)
#'
#' @return Returns data with components
#' \item{\code{Intercept}: }{Column of ones.}
#' \item{\code{EmpCat}: }{Indicator for employment status.}
#' \item{\code{IncomeCat}: }{Indicator for household income > $75,000.}
#' \item{\code{Bachelors}: }{Individual's highest degree is Bachelors.}
#' \item{\code{Post.Bachelors}: }{Indicator for highest degree is Masters, Professional or Doctorate.}
#' \item{\code{Computers}: }{Indicator for computer ownership by individual or household.}
#' \item{\code{CellPhone}: }{Indicator for cellphone ownership by individual or household.}
#' \item{\code{White}: }{Indicator for White race.}
#' \item{\code{y}: }{Public opinion on the proposal to raise federal income taxes. The three categories are: oppose, neither
#' favor nor oppose, or favor the tax increase.}
#'
#' @references Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
#' Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
#'
#' @keywords datasets
#'
#' @seealso \href{https://electionstudies.org/data-center/}{ANES},  \href{https://georgewbush-whitehouse.archives.gov/cea/progrowth.html}{Tax Policy}
#'
NULL

