% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flippedBraid.R
\name{evalFlippedBraidModel}
\alias{evalFlippedBraidModel}
\title{Evaluate Flipped BRAID Surfaces}
\usage{
evalFlippedBraidModel(DA, DB, bpar, flip)
}
\arguments{
\item{DA}{A vector of concentrations of drug A in a combination (values 0
and \code{Inf} are permitted). Must be length 1 or the same length as \code{DB}.}

\item{DB}{A vector of concentrations of drug B in a combination (values 0
and \code{Inf} are permitted). Must be length 1 or the same length as \code{DA}.}

\item{bpar}{Flipped-BRAID parameter of the flipped response surface. See
details for more information on specifying atypical surfaces}

\item{flip}{String specifying the direction or directions of the surface's
flip.  Must be one of "A", "B", or "both".}
}
\value{
A numeric vector the same length as \code{DA}  and/or \code{DB} with the
predicted flipped BRAID response surface values.
}
\description{
Evaluate Flipped BRAID Surfaces
}
\details{
While the BRAID model generates a fairly versatile range of combined
behaviors, the traditional model is still strictly constrained in certain
respects.  Response surfaces must exhibit a change in response to both drugs
and this change must be in the same direction.  Furthermore, the model is
only suited to surfaces in which the change resulting from single drugs is
larger than the additional effect of the combination.  However, modifying
the model equation by inverting one or both of the slope parameters can
produce a set of qualitatively distinct "flipped" surfaces, allowing the
model to produce a much wider range of behaviors.  For example, flipping the
model along the axis representing drug A can produce a surface in which drug
B has no effect in isolation, but attenuates or eliminates the effect of
drug A, a pattern we call a "protective" surface.  See \code{\link[=fitBraidFlipped]{fitBraidFlipped()}}
for the possible range of surfaces.

An important note: a flipped BRAID surface, like a traditional BRAID surface,
is represented by a parameter vector of up to 9 values.  While these
functions will attempt to fill a 7- or 8- value parameter factor to a full
9-element vector, it is strongly recommended that you specify the response
surface with the full 9-element vector, as the precise ordering with which
implicit values are arranged can be extremely confusing.  Note also that
flipped parameter vectors, regardless of the underlying mathematical
representation, should always be specified in the same order as in a
traditional vector.  So in a full 9-element vector:
\itemize{
\item Parameter 6 (E0) should always specify the expected effect when both drugs
are absent
\item Parameter 7 (EfA) should always specify the expected effect at high
concentrations of drug A when drug B is absent
\item Parameter 8 (EfB) should always specify the expected effect at high
concentrations of drug B when drug A is absent
\item Parameter 9 (Ef) should always specify the expected effect when both drugs
are present at high concentrations
}
}
\examples{
concentrations <- c(0, 2^(-3:3))
surface <- data.frame(
    concA = rep(concentrations,each=length(concentrations)),
    concB = rep(concentrations,times=length(concentrations))
)

surface$protective <- evalFlippedBraidModel(
    surface$concA,
    surface$concB,
    c(1, 1, 3, 3, 0, 0, 100, 0, 10),
    flip="A"
)
surface$coactive <- evalFlippedBraidModel(
    surface$concA,
    surface$concB,
    c(1, 1, 3, 3, 0, 0, 0, 0, 100),
    flip="both"
)

head(surface)
}
