% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braids.R
\name{tau}
\alias{tau}
\title{Inner automorphism}
\usage{
tau(braid)
}
\arguments{
\item{braid}{a \code{braid} object}
}
\value{
A \code{braid} object.
}
\description{
The inner automorphism defined by
  \eqn{\tau X = \Delta^{-1} X \Delta}, where \eqn{\Delta} is the
  positive half-twist; it sends each generator \eqn{\sigma_j} to
  \eqn{\sigma_{n-j}}.
}
\examples{
braid <- mkBraid(4, c(2, -3, 3))
tau(braid)
}
