% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwr_auth.R
\name{bwr_auth}
\alias{bwr_auth}
\title{Authenticate with the Brandwatch API}
\usage{
bwr_auth(un = NULL, pw = NULL, refresh = FALSE, cache = TRUE)
}
\arguments{
\item{un}{Your Brandwatch Username}

\item{pw}{Your Brandwatch Password}

\item{refresh}{(Boolean) Should the token be refreshed?
If no, a token will be read from a locally cached file '.bw_token' if this file is available.
If no token is available, or the refresh argument is TRUE, a new token will be requested and cached from the API.}

\item{cache}{(Boolean) Can the token be locally cached?
If TRUE, the token will be cached in the current working directory in '.bw_token'.
If FALSE, the token will be not be cached locally.}
}
\value{
Invisibly returns the string containing the token returned by Brandwatch.
Your environment variable 'BW_TOKEN' will be set to the value of your authentication token.
}
\description{
Authenticates using specified username and password.
Also caches a local version of the authentication token unless otherwise specified.
}
\examples{
\dontrun{bwr_auth(un = 'mickey@mouse.com', pw = 'itsasmallworld')}
}
