% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{bwr_query_create}
\alias{bwr_query_create}
\title{Upload a new query to Brandwatch}
\usage{
bwr_query_create(project_id = NULL, type = "search string",
  languageAgnostic = FALSE, samplePercent = 100, languages = "en",
  includedTerms = NULL, name = NULL, description = "My API query",
  industry = "general", token = Sys.getenv("BW_TOKEN"))
}
\arguments{
\item{project_id}{The project ID into which you'd like to insert a query}

\item{type}{The type of query (e.g. 'search string')}

\item{languageAgnostic}{(Boolean) Is the query language agnostic?}

\item{samplePercent}{(Numeric) The sample percent for the given query}

\item{languages}{Which languages to include}

\item{includedTerms}{The query syntax to be included.}

\item{name}{The name of the query}

\item{description}{The description of the query}

\item{industry}{The industry classification}

\item{token}{The authentication token, obtained using bwr_auth()}
}
\value{
Returns a list containing the JSON response from the server.
}
\description{
Refer to https://developers.brandwatch.com/docs/creating-queries for more information.
Unless otherwise specified, provide a single string argument.
}
\examples{
\dontrun{bwr_query_create(project_id = 12423432,
                 samplePercent = 50,
                 includedTerms = 'at_mentions:mickeymouse',
                 name = 'Sample API query')}
}
