% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wemgsc.R
\name{sol.wcm}
\alias{sol.wcm}
\title{Solution path generation via the Wild Contrast Maximisation method}
\usage{
sol.wcm(
  x,
  type = "const",
  M = 100,
  min.d = NULL,
  Q = floor(log(length(x))^1.9),
  max.iter = 5
)
}
\arguments{
\item{x}{A numeric vector containing the data to be processed.}

\item{type}{The type of change-point models fitted to the data; currently the class of piecewise constant signals (\code{type = "const"}) is supported.}

\item{M}{The maximum number of data sub-samples drawn at each recursive stage of the algorithm. The default is \code{M = 100}.}

\item{min.d}{The minimum distance between candidate change-point estimators; 
if \code{min.d = NULL}, it is set to be \code{max(20, 10 + ceiling(log(length(x))^1.1)}.}

\item{Q}{The maximum number of allowable change-points. 
The default is \code{Q = floor(log(length(x))^1.9)}.}

\item{max.iter}{The maximum number of candidate change-point models considered; if a model with the number of change-point estimators exceeding \code{Q} is required to generate the sequence of required candidate models, this argument is ignored. The default is \code{max.iter = 5}.}
}
\value{
An S3 object of class \code{cptpath}, which contains the following fields: 
\item{solutions.nested}{\code{TRUE}, i.e., the change-point outputs are nested}
\item{solution.path}{Locations of possible change-points in the mean of \code{x}, arranged in decreasing order of change-point importance; this is not used by \code{\link{model.gsa}}}
\item{solution.set}{A list of candidate change-point models. Each model contains possible change-points in the mean of \code{x}; this is used by \code{\link{model.gsa}}}
\item{x}{Input vector \code{x}}
\item{type}{The type of the change-point model considered, which has value "const" here}
\item{M}{Input parameter \code{M}}
\item{cands}{Matrix of dimensions \code{Q} by 4. The first two columns are (start, end)-points of the detection intervals of the corresponding possible change-point location in the third column. The fourth column is a measure of strength of the corresponding possible change-point. The order of the rows is the same as the order returned in \code{solution.path}}
\item{method}{The method used, which has value "wcm" here}
}
\description{
This function arranges all possible change-points in the mean of the input vector in the order of importance, via the Wild Binary Segmentation 2 method.
}
\details{
The Wild Contrast Maximisation (WCM) algorithm generates a nested sequence of candidate models by identifying large gaps in the solution path generated by WBS2, which aids the model selection step in the presence of large random fluctuations due to serial dependence. See Cho and Fryzlewicz (2023) for further details.
}
\examples{
set.seed(111)
f <- rep(c(0, 5, 2, 8, 1, -2), c(100, 200, 200, 50, 200, 250))
x <- f + arima.sim(list(ar = c(.75, -.5), ma = c(.8, .7, .6, .5, .4, .3)), n = length(f), sd = 1)
sol.wcm(x)$solution.set
}
\references{
H. Cho & P. Fryzlewicz (2024) Multiple change point detection under serial dependence: Wild contrast maximisation and gappy Schwarz algorithm. \emph{Journal of Time Series Analysis}, 45(3): 479--494.
}
\seealso{
\code{\link{model.gsa}}
}
