% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-RNA_halflife_3models.R
\name{BridgeRHalfLifeCalc3models}
\alias{BridgeRHalfLifeCalc3models}
\title{Calculate RNA half-life for each gene using 3model method.}
\usage{
BridgeRHalfLifeCalc3models(inputFile, group = c("Control", "Knockdown"),
  hour = c(0, 1, 2, 4, 8, 12), inforColumn = 4, CutoffTimePointNumber = 4,
  save = T, outputPrefix = "BridgeR_5")
}
\arguments{
\item{inputFile}{The vector of tab-delimited matrix file.}

\item{group}{The vector of group names.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{inforColumn}{The number of information columns.}

\item{CutoffTimePointNumber}{The number of minimum time points for calc.}

\item{save}{Whether to save the output matrix file.}

\item{outputPrefix}{The prefix for the name of the output.}
}
\value{
data.table object about RNA half-life, R2 and fitting model.
}
\description{
\code{BridgeRHalfLifeCalc3models} calculates RNA half-life for each gene
using 3 models methods (older version).
}
\examples{
library(data.table)
normalized_rpkm_matrix <- data.table(gr_id = c(8, 9, 14),
                                     symbol = c("AAAS", "AACS", "AADAT"),
                                     accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                                     locus = c("chr12", "chr12", "chr4"),
                                     CTRL_1_0h = c(1.00, 1.00, 1.00),
                                     CTRL_1_1h = c(1.00, 0.86, 0.96),
                                     CTRL_1_2h = c(1.00, 0.96, 0.88),
                                     CTRL_1_4h = c(1.00, 0.74, 0.85),
                                     CTRL_1_8h = c(1.00, 0.86, 0.68),
                                     CTRL_1_12h = c(1.01, 0.65, 0.60),
                                     gr_id = c(8, 9, 14),
                                     symbol = c("AAAS", "AACS", "AADAT"),
                                     accession_id = c("NM_015665", "NM_023928", "NM_182662"),
                                     locus = c("chr12", "chr12", "chr4"),
                                     KD_1_0h = c(1.00, 1.00, 1.00),
                                     KD_1_1h = c(1.01, 0.73, 0.71),
                                     KD_1_2h = c(1.01, 0.77, 0.69),
                                     KD_1_4h = c(1.01, 0.72, 0.67),
                                     KD_1_8h = c(1.01, 0.64, 0.38),
                                     KD_1_12h = c(1.00, 0.89, 0.63))
group <- c("Control", "Knockdown")
hour <- c(0, 1, 2, 4, 8, 12)
halflife_table <- BridgeRHalfLifeCalc3models(normalized_rpkm_matrix,
                                             group = group,
                                             hour = hour,
                                             save = FALSE)

}

