% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-halflife_SD.R
\name{CalcHalflifeDeviation}
\alias{CalcHalflifeDeviation}
\title{Calculate RNA half-life SD.}
\usage{
CalcHalflifeDeviation(inputFile, rawFile, group = c("CTRL_PUM1", "CTRL_PUM2",
  "CTRL_DKD"), hour = c(0, 1, 2, 4, 8, 12), save = T, figSave = F,
  inforColumn = 4, outputPrefix = "BridgeR_7")
}
\arguments{
\item{inputFile}{The dataframe of halflife table.}

\item{rawFile}{The dataframe of RPKM table.}

\item{group}{The vector of group names.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{save}{Whether to save the output matrix file.}

\item{figSave}{Whether to save the output fig file.}

\item{inforColumn}{The number of information columns.}

\item{outputPrefix}{The prefix for the name of the output.}
}
\value{
data.table object about RNA half-life SD.
}
\description{
\code{BridgeRHalfLifeCalcR2Select} calculates RPKM SD and RNA half-life SD
for each gene.
}
\examples{
group <- c("Control", "Knockdown")
hour <- c(0, 1, 2, 4, 8, 12)
half_sd_table <- CalcHalflifeDeviation(halflife_table,
                                       RNA_halflife_grubbs_test,
                                       group = c("CTRL_1",
                                                 "CTRL_2",
                                                 "CTRL_3"),
                                       save = FALSE)

}

