% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_utility}
\alias{plot_utility}
\title{Plot Posterior Mean Utility Scores}
\usage{
plot_utility(x, reference = NULL, stacked = FALSE)
}
\arguments{
\item{x}{output from a call to \code{br()} or \code{mcda()}.}

\item{reference}{a string indicating which group is the reference group which
is used to subtract scores from other groups.}

\item{stacked}{logical indicating if a stacked version of the barplot should
be produced.}
}
\value{
A ggplot barplot of the posterior mean weighted utility scores.
}
\description{
Plot Posterior Mean Utility Scores
}
\examples{
set.seed(1132)
ilogit <- function(x) 1 / (1 + exp(-x))
out <- mcda(
  benefit("CV", function(x) ilogit(x), weight = .75),
  risk("DVT", function(x) ilogit(- .5 * x), weight = .25),
  br_group(
    label = "PBO",
    CV = rnorm(1e4, .1),
    DVT = rnorm(1e4, .1)
  ),
  br_group(
    label = "TRT",
    CV = rnorm(1e4, 2),
    DVT = rnorm(1e4, 1)
  )
)

out

summary(out, probs = c(.025, .5, .975))
summary(out, reference = "PBO")

plot(out)
plot(out, reference = "PBO")

plot_utility(out)
plot_utility(out, reference = "PBO")
plot_utility(out, stacked = TRUE)
}
\seealso{
Other plots: 
\code{\link{plot.brisk_br}()}
}
\concept{plots}
