% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benefit_risk.R
\name{summary.brisk_br}
\alias{summary.brisk_br}
\title{Summarize Bayesian Benefit-Risk Scores}
\usage{
\method{summary}{brisk_br}(object, probs = c(0.025, 0.975), reference = NULL, ...)
}
\arguments{
\item{object}{output from a call to \code{brisk::br()} or \code{brisk::mcda()}.}

\item{probs}{a vector of probabilities used to obtain quantiles of
the posterior of the weighted utilities for each group.}

\item{reference}{a string indicating which group is the reference group which
is used to subtract scores from other groups.}

\item{...}{Additional arguments which throw an error if specified.}
}
\value{
A named list with the posterior summary, and the scores from the
\code{object} object (which are adjusted if \code{reference} is specified).
}
\description{
Summarize Bayesian Benefit-Risk Scores
}
\examples{
set.seed(1132)
out <- br(
  benefit("CV", function(x) x, weight = 1),
  risk("DVT", function(x) - .5 * x, weight = 1),

  br_group(
    label = "PBO",
    CV = rnorm(1e4, .1),
    DVT = rnorm(1e4, .1)
  ),
  br_group(
    label = "TRT",
    CV = rnorm(1e4, 2),
    DVT = rnorm(1e4, 1)
  )
)

out

summary(out, probs = c(.025, .5, .975))
summary(out, reference = "PBO")

plot(out)
# adjusted relative to PBO
plot(out, reference = "PBO")

plot_utility(out)
plot_utility(out, reference = "PBO")
plot_utility(out, stacked = TRUE)
}
