% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_formula_sigma.R
\name{brm_formula_sigma}
\alias{brm_formula_sigma}
\title{Formula for standard deviation parameters}
\usage{
brm_formula_sigma(
  data,
  check_rank = TRUE,
  intercept = FALSE,
  baseline = FALSE,
  baseline_subgroup = FALSE,
  baseline_subgroup_time = FALSE,
  baseline_time = FALSE,
  covariates = FALSE,
  group = FALSE,
  group_subgroup = FALSE,
  group_subgroup_time = FALSE,
  group_time = FALSE,
  subgroup = FALSE,
  subgroup_time = FALSE,
  time = TRUE
)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}, or an informative
prior archetype from a function like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.}

\item{check_rank}{\code{TRUE} to check the rank of the model matrix
for \code{sigma} and throw an error if rank deficiency is detected.
\code{FALSE} to skip this check.
Rank-deficiency may cause \code{sigma} to be non-identifiable,
may prevent the MCMC from converging.}

\item{intercept}{Logical of length 1.
\code{TRUE} (default) to include an intercept, \code{FALSE} to omit.}

\item{baseline}{Logical of length 1.
\code{TRUE} to include an additive effect for baseline
response, \code{FALSE} to omit.
If \code{TRUE}, then effect size will be omitted from the output of
\code{\link[=brm_marginal_draws]{brm_marginal_draws()}}.}

\item{baseline_subgroup}{Logical of length 1.}

\item{baseline_subgroup_time}{Logical of length 1.
\code{TRUE} to include baseline-by-subgroup-by-time interaction,
\code{FALSE} to omit.
If \code{TRUE}, then effect size will be omitted from the output of
\code{\link[=brm_marginal_draws]{brm_marginal_draws()}}.}

\item{baseline_time}{Logical of length 1.
\code{TRUE} to include baseline-by-time interaction, \code{FALSE} to omit.
If \code{TRUE}, then effect size will be omitted from the output of
\code{\link[=brm_marginal_draws]{brm_marginal_draws()}}.}

\item{covariates}{Logical of length 1.
\code{TRUE} (default) to include any additive covariates declared with
the \code{covariates} argument of \code{\link[=brm_data]{brm_data()}},
\code{FALSE} to omit.
If \code{TRUE}, then effect size will be omitted from the output of
\code{\link[=brm_marginal_draws]{brm_marginal_draws()}}.}

\item{group}{Logical of length 1.
\code{TRUE} (default) to include additive effects for
treatment groups, \code{FALSE} to omit.}

\item{group_subgroup}{Logical of length 1.
\code{TRUE} to include group-by-subgroup interaction, \code{FALSE} to omit.}

\item{group_subgroup_time}{Logical of length 1.
\code{TRUE} to include group-by-subgroup-by-time interaction, \code{FALSE} to omit.}

\item{group_time}{Logical of length 1.}

\item{subgroup}{Logical of length 1.
\code{TRUE} to include additive fixed effects for subgroup levels,
\code{FALSE} to omit.}

\item{subgroup_time}{Logical of length 1.
\code{TRUE} to include subgroup-by-time interaction, \code{FALSE} to omit.}

\item{time}{Logical of length 1.}
}
\value{
A base R formula with S3 class \code{"brms_mmrm_formula_sigma"}.
This formula controls the parameterization of \code{sigma}, the linear-scale
\code{brms} distributional parameters which represent standard deviations.
}
\description{
Parameterize standard deviations using
a formula for the \code{sigma} argument of \code{\link[=brm_formula]{brm_formula()}}.
}
\details{
In \code{brms}, the standard deviations of the residuals are
modeled through a parameter vector called \code{sigma}. \code{brms.mmrm}
always treats \code{sigma} as a distributional parameter
(\url{https://paulbuerkner.com/brms/articles/brms_distreg.html}).
\code{\link[=brm_formula_sigma]{brm_formula_sigma()}} lets you control the parameterization of \code{sigma}.
The output of \code{\link[=brm_formula_sigma]{brm_formula_sigma()}} serves as input to the \code{sigma}
argument of \code{\link[=brm_formula]{brm_formula()}}.

The default \code{sigma} formula is \code{sigma ~ 0 + time}, where \code{time}
is the discrete time variable in the data. This is the usual
heterogeneous variance structure which declares
one standard deviation parameter for each time point in the data.
Alternatively, you could write
\code{brm_formula_sigma(data, intercept = TRUE, time = FALSE)}.
This will produce \code{sigma ~ 1}, which yields a single scalar variance
(a structure termed "homogeneous variance").

With arguments like \code{baseline} and \code{covariates}, you can
specify extremely complicated variance structures. However,
if baseline or covariates are used, then the output of
\code{\link[=brm_marginal_draws]{brm_marginal_draws()}} omit effect size due to the statistical
challenges of calculating marginal means of draws of \code{sigma}
for this uncommon scenario.
}
\examples{
set.seed(0)
data <- brm_data(
  data = brm_simulate_simple()$data,
  outcome = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
homogeneous <- brm_formula_sigma(data, time = FALSE, intercept = TRUE)
by_group <- brm_formula_sigma(data, group = TRUE, intercept = TRUE)
homogeneous
by_group
brm_formula(data, sigma = homogeneous)
brm_formula(data, sigma = by_group)
}
\seealso{
Other models: 
\code{\link{brm_formula}()},
\code{\link{brm_model}()}
}
\concept{models}
