% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_marginal_grid.R
\name{brm_marginal_grid}
\alias{brm_marginal_grid}
\title{Marginal names grid.}
\usage{
brm_marginal_grid(data, formula)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}, or an informative
prior archetype from a function like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full mapping
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}
}
\value{
A data frame with a \code{name} column with the names of columns of
data frames in \code{\link[=brm_marginal_draws]{brm_marginal_draws()}}, along with metadata to
describe which groups, subgroups, and time points those columns
correspond to.
}
\description{
Describe the column names of the data frames output
by \code{\link[=brm_marginal_draws]{brm_marginal_draws()}}.
}
\details{
Useful for creating custom posterior summaries from the draws.
}
\examples{
data <- brm_simulate_outline()
brm_marginal_grid(data, brm_formula(data))
data <- brm_simulate_outline(n_subgroup = 2L)
brm_marginal_grid(data, brm_formula(data))
}
\seealso{
Other marginals: 
\code{\link{brm_marginal_data}()},
\code{\link{brm_marginal_draws}()},
\code{\link{brm_marginal_draws_average}()},
\code{\link{brm_marginal_probabilities}()},
\code{\link{brm_marginal_summaries}()}
}
\concept{marginals}
