% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{bsnsing}
\alias{bsnsing}
\title{Learn a Classification Tree using Boolean Sensing}
\usage{
bsnsing(x, ...)
}
\arguments{
\item{x}{a data frame or a \code{\link[stats]{formula}} object.}

\item{...}{arguments passed on to \code{\link{bsnsing.default}} or \code{\link{bsnsing.formula}}.}
}
\value{
an object of class \code{bsnsing} for a two-class problem or an object of class \code{mbsnsing} for a multi-class problem.
}
\description{
Depending on the arguments provided, either \code{\link[bsnsing]{bsnsing.default}} or \code{\link[bsnsing]{bsnsing.formula}} will be called.
}
\examples{
# Use the formula format
bs <- bsnsing(Class~., data = BreastCancer)
summary(bs)
# For multi-class classification
bs <- bsnsing(Species ~ ., data = iris)
summary(bs)
summary(bs[[1]])  # display the tree for the first class
summary(bs[[2]])  # display the tree for the second class
summary(bs[[3]])  # display the tree for the third class
predict(bs, type = 'class')  # the fitted class membership
predict(bs, type = 'prob')  # the fitted probabilities

# Use the (x, y) format, y must have two levels
y <- ifelse(iris$Species == 'setosa', 1L, 0L)
x <- iris[, c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width')]
bs <- bsnsing(x, y, verbose = TRUE)
summary(bs)

}
