% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_SP500.R
\name{proc_SP500}
\alias{proc_SP500}
\title{Preprocess SP500 data}
\usage{
proc_SP500(SP500data, sectors)
}
\arguments{
\item{SP500data}{A data frame containing SP500 stock data with columns including:
\describe{
  \item{symbol}{Stock symbol.}
  \item{date}{Date of the stock data.}
  \item{adjusted}{Adjusted closing price of the stock.}
  \item{sector}{Sector of the stock.}
}}

\item{sectors}{A character vector specifying the sectors to include in the analysis.}
}
\value{
A list with components:
  \item{Uhat}{A matrix of idiosyncratic errors.}
  \item{Khat}{Estimated number of factors.}
  \item{factorparthat}{Estimated factor returns.}
  \item{sectornames}{Sector for each column of \code{Uhat}.}
}
\description{
The \code{proc_SP500} function preprocesses the SP500 stock data by calculating monthly
returns for selected sectors and generating idiosyncratic errors.
}
\details{
\enumerate{
   \item Calculates monthly returns for each stock in the specified sectors  
   \item Estimates the number of factors via \code{hdbinseg::get.factor.model(ic="ah")}  
   \item Uses \code{POET::POET()} to extract factor loadings/factors and form idiosyncratic errors  
}
}
\examples{

data("SP500")
set.seed(1234)
sectors <- c("Energy", "Financials", "Materials",
   "Real Estate", "Utilities", "Information Technology")
\donttest{
Uhat <- proc_SP500(SP500, sectors)$Uhat
PPPres <- thresPPP(Uhat, eps = 0, thres = list(value = 0.0020, fun = "hard"), nsample = 100)
postmean <- estimate(PPPres)
diag(postmean) <- 0 # hide color for diagonal
plot(postmean)}

}
