% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrangeFunctions.R
\name{matchLayoutHeights}
\alias{matchLayoutHeights}
\alias{matchLayoutWidths}
\title{Match Viewport Layout Dimensions.}
\usage{
matchLayoutHeights(x, r1 = 1, r2 = 5)

matchLayoutWidths(x, c1 = 1, c2 = 5)
}
\arguments{
\item{x}{A list of bubbleHeatmap trees}

\item{r1, r2}{Numeric between 1 and 6, the first (r1) and last (r2) viewport
layout rows to be aligned.}

\item{c1, c2}{Numeric between 1 and 9, the first (c1) and last (c2) viewport
layout columns to be aligned.}
}
\value{
The input list of bubbleHeatmap trees modified so that the maximum
height/width of a given row/column in any input tree is applied to that
row/column for all trees in the list, for the rows/columns specified by the
r/c parameters.
}
\description{
Align the dimensions of the viewport layouts in a list of bubbleHeatmap
gTrees. The maximum height/width of a given row/column in any input tree will
be applied that row/column for all trees in the list. This enables the plots
to be aligned in mult-plot figure layouts, for example the "TopLabels"
element can be given the same height in two plots that are to be positioned
side by side.
}
\section{Functions}{
\itemize{
\item \code{matchLayoutHeights()}: Align layout row heights across multiple
bubbleHeatmap trees.

\item \code{matchLayoutWidths()}: Align layout column widths across multiple
bubbleHeatmap trees.

}}
