% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myimpute.R
\name{mlgp}
\alias{mlgp}
\title{Impute missing data.}
\usage{
mlgp(y, x, tol = 1e-06)
}
\arguments{
\item{y}{Numeric y vector of response values.}

\item{x}{Numeric x vector of locations used for the covariance function.}

\item{tol}{Tolerance level for the maximum likelihood procedure to fit the Gaussian process.}
}
\value{
Standard optim output. The first optimized parameter value is the standard deviation
  the second is the length scale.
}
\description{
This function performs maximum likelihood estimation to estimate the variance parameters
in a Gaussian process with a squared exponential covariance function. These parameters could then be used
in the Gaussian process used for imputation.
}
\examples{
# Fake data
sim_groove <- function(beta = c(-0.28,0.28), a = 125)
{
    x <- seq(from = 0, to = 2158, by = 20)
    med <- median(x)
    y <- 1*(x <= a)*(beta[1]*(x - med) - beta[1]*(a - med)) +
    1*(x >= 2158 - a)*(beta[2]*(x - med) - beta[2]*(2158 - a - med))
    return(data.frame("x" = x, "y" = y))
}

fake_groove <- sim_groove()
fake_groove <- fake_groove[sample.int(n = nrow(fake_groove),
    size = round(0.8 * nrow(fake_groove)),
    replace = FALSE),]
plot(fake_groove$x, fake_groove$y)


# estimate the MLE's
mles <- mlgp(y = fake_groove$y, x = fake_groove$x)
}
