% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_aBullCallSpread.R
\name{aBullCallSpread}
\alias{aBullCallSpread}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven (BE) point at expiration for Bull Call Spread and draws its graph in the Plots tab.}
\usage{
aBullCallSpread(
  ST,
  XH,
  XL,
  CL,
  CH,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Bull Call Spread ",
  sub = " bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{XH}{Higher Strike Price or eXercise price.}

\item{XL}{Lower Strike Price or eXercise price.}

\item{CL}{Call Premium paid for the bought Call at Lower Strike.}

\item{CH}{Call Premium received for the sold Call at Higher Strike.}

\item{hl}{lower bound value for setting lower limit of  X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of  X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Bull Call Spread.
}
\description{
The trading strategy that is implemented with an expectation that the price of the stock or the underlying will rise in future is called a bullish strategy. As explained by Chance (2019), an option is a derivative contract in which one party, the buyer, pays a sum of money to the other party, the seller or writer, and receives the right to either buy (known as call option) or right to sell (known as put option) an underlying asset at a fixed price either on a specific expiration date (European option) or at any time prior to the expiration date (American Option). So the right to buy is one type of option, referred to as a call or call option, whereas the right to sell is another type of option, referred to as a put or put option.\cr
Further, it is explained by Chance (2019) that a derivative is a financial instrument that derives its performance from the performance of an underlying asset. Derivatives can be used as insurance that allows for the transfer of risk from one party to another. As everyone knows, insurance is a financial contract that provides protection against loss. The party bearing the risk purchases an insurance policy, which transfers the risk to the other party, the insurer, for a specified period of time. The risk itself does not change, but the party bearing it does. Derivatives allow for this same type of transfer of risk.\cr
Derivatives are associated with an underlying asset. As such, the underlying asset is often simply referred to as the underlying, whose value is the source of risk. Derivatives are created in the form of legal contracts. They involve two parties: the buyer and the seller (sometimes known as the writer); each of whom agrees to do something for the other, either now or later. The buyer, who purchases the derivative, is referred to as the long or the holder because he owns (or holds) the derivative and holds a long position. The seller is referred to as the short because he holds a short position (Chance, 2019).\cr
}
\details{
This is a vertical spread consisting of a long position in a close to ATM (at the money) call option with a strike price XL, and a short position in an OTM (out of the money) call option with a higher strike price XH. This is a net debit (V0Dr) trade as option premium or option price (CH) received on call shorted at higher strike price (XH) is less than premium or price (CL) paid for the call bought at lower strike price (XL). So, V0Dr is equal to CL minus CH. The outlook of the trader (or investor) is bullish and the strategy profits if the stock price rises (Kakushadze & Serur, 2018).\cr
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and Breakeven(BE) point for Bull Call Spread and draws its graph in the Plots tab.
}
\examples{
aBullCallSpread(17,17,15,1.64,0.51)
aBullCallSpread(50,50,47,5,3.2,hl=0.7,hu=1.2)
aBullCallSpread(1000,1000,998,14.5,13.25,hl=0.98,hu=1.02)
}
\references{
Chance,D.M.(2019). Basics of Derivative Pricing and Valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 385-453). Wiley Professional Development (P&T). ISBN 9781119593577, https://bookshelf.vitalsource.com/books/9781119593577\cr
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
