% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_estimate_transmissision_flows.r
\name{estimate_theta_hat}
\alias{estimate_theta_hat}
\alias{theta_hat}
\alias{est_theta_hat}
\alias{estim_theta_hat}
\alias{estimate_theta_hat.default}
\title{\code{estimate_theta_hat} Estimates conditional probability of linkage (transmission flows)}
\usage{
estimate_theta_hat(df_counts_and_p_hat, ...)

\method{estimate_theta_hat}{default}(df_counts_and_p_hat, ...)
}
\arguments{
\item{df_counts_and_p_hat}{A data.frame returned by the function: \code{\link[=estimate_p_hat]{estimate_p_hat()}}}

\item{\dots}{Further arguments.}
}
\value{
Returns a data.frame containing:
\itemize{
\item H1_group, Name of population group 1
\item H2_group, Name of population group 2
\item number_hosts_sampled_group_1, Number of individuals sampled from population group 1
\item number_hosts_sampled_group_2, Number of individuals sampled from population group 2
\item number_hosts_population_group_1, Estimated number of individuals in population group 1
\item number_hosts_population_group_2, Estimated number of individuals in population group 2
\item max_possible_pairs_in_sample, Number of distinct possible transmission pairs between individuals sampled from population groups 1 and 2
\item max_possible_pairs_in_population, Number of distinct possible transmission pairs between individuals in population groups 1 and 2
\item num_linked_pairs_observed, Number of observed directed transmission pairs between samples from population groups 1 and 2
\item p_hat, Probability that pathogen sequences from two individuals randomly sampled from their respective population groups are linked
\item est_linkedpairs_in_population, Estimated transmission pairs between population groups 1 and 2
\item theta_hat, Estimated transmission flows or relative probability of transmission within and between population groups 1 and 2 adjusted
for sampling heterogeneity. More precisely, the conditional probability that a pair of pathogen sequences is from a specific population
group pairing given that the pair is linked.}
}
\description{
This function estimates \code{theta_hat}, the relative probability of
transmission within and between population groups accounting for variable
sampling rates among population groups. This relative probability is also
refferred to as transmission flows.
}
\details{
For a population group pairing \eqn{(u,v)}, the estimated transmission flows
within and between population groups \eqn{u} and \eqn{v}, are represented by
the vector theta_hat,

\deqn{\hat{\theta} = ( \hat{\theta}_{uu}, \hat{\theta}_{uv}, \hat{\theta}_{vu}, \hat{\theta}_{vv} ) ,}

and are computed as \deqn{\hat{\theta_{ij}} = Pr(pair from groups (i,j) | pair is linked), where i = u,v and j = u,v ,}

\deqn{\hat{\theta_{ij}} = \frac{N_{ij}p_{ij}}{ \sum_m \sum_{n \ge m}N_{mn}p_{mn}}, where i = u,v and j = u,v ,}

See bumblebee website for more details \url{https://magosil86.github.io/bumblebee/}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Estimates conditional probability of linkage (transmission flows)
}}

\examples{
library(bumblebee)
library(dplyr)

# Estimate transmission flows within and between population groups accounting for variable
# sampling among population groups

# We shall use the data of HIV transmissions within and between intervention and control
# communities in the BCPP/Ya Tsie HIV prevention trial. To learn more about the data 
# ?counts_hiv_transmission_pairs and ?sampling_frequency


# Load and view data
#
# The input data comprises counts of observed directed HIV transmission pairs within 
# and between intervention and control communities in the BCPP/Ya Tsie trial,
# sampling information and the probability of linkage between individuals sampled
# from intervention and control communities (i.e. \code{p_hat})
#
# See ?estimate_p_hat() for details on estimating p_hat
results_estimate_p_hat <- estimated_hiv_transmission_flows[, c(1:10)]

results_estimate_p_hat

# Estimate theta_hat
results_estimate_theta_hat <- estimate_theta_hat(df_counts_and_p_hat = results_estimate_p_hat)

# View results
results_estimate_theta_hat

}
\references{
\enumerate{

\item Magosi LE, et al., Deep-sequence phylogenetics to quantify patterns of
HIV transmission in the context of a universal testing and treatment
trial – BCPP/ Ya Tsie trial. To submit for publication, 2021.

\item Carnegie, N.B., et al., Linkage of viral sequences among HIV-infected
village residents in Botswana: estimation of linkage rates in the
presence of missing data. PLoS Computational Biology, 2014. 10(1):
p. e1003430.

}
}
\seealso{
See \code{\link{estimate_p_hat}} to prepare input data to estimate \code{theta_hat}
}
