% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst_unadj.R
\name{rmst_unadjust}
\alias{rmst_unadjust}
\title{Calculate the unadjusted restricted mean survival time (RMST)}
\usage{
rmst_unadjust(time, status, trt, tau)
}
\arguments{
\item{time}{A vector containing the event time of the sample.}

\item{status}{A vector containing the survival status of the sample.}

\item{trt}{A vector indicating the treatment assignment. 1 for treatment group. 0 for placebo group.}

\item{tau}{Numeric. A value for the restricted time or the pre-specified cutoff time point.}
}
\value{
A data frame including the survival time for each trt and the difference. SE were also calculated.
\describe{
\item{mu0}{Mean survival time for trt0}
\item{se0}{SE of mu0}
\item{mu1}{Mean survival time for trt1}
\item{se1}{SE of mu1}
\item{delta}{Difference between mu0 and mu1}
\item{se_d}{SE of delta}
}
}
\description{
Estimate the unadjusted RMST (point estimate).
}
\examples{

data("oak")
tau <- 26
time <- oak$OS
status <- oak$os.status
trt <- oak$trt
covariates <- oak[, c("btmb", "pdl1")]
results <- rmst_unadjust(time, status, trt, tau)

}
