% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burgle_CSC.R, R/burgle_cph.R,
%   R/burgle_flexsurv.R, R/burgle_multinom.R, R/burgle_survival.R,
%   R/predict_burgle.R
\name{predict_burgle}
\alias{predict_burgle}
\alias{predict.burgle_CauseSpecificCox}
\alias{predict.burgle_cph}
\alias{predict.burgle_flexsurvreg}
\alias{predict.burgle_multinom}
\alias{predict.burgle_coxph}
\alias{predict.burgle_lm}
\alias{predict.burgle_glm}
\title{Predict for burgle methods}
\usage{
\method{predict}{burgle_CauseSpecificCox}(
  object,
  newdata = NULL,
  type = "lp",
  cause = 1,
  original = TRUE,
  draws = 1,
  sims = 1,
  times = NULL,
  ...
)

\method{predict}{burgle_cph}(object, ...)

\method{predict}{burgle_flexsurvreg}(
  object,
  newdata = NA,
  original = TRUE,
  draws = 1,
  sims = 1,
  type = "lp",
  times = NULL,
  ...
)

\method{predict}{burgle_multinom}(
  object,
  newdata = NA,
  original = TRUE,
  draws = 1,
  sims = 1,
  type = "lp",
  floor = FALSE,
  seed = NULL,
  ...
)

\method{predict}{burgle_coxph}(
  object,
  newdata = NA,
  original = TRUE,
  draws = 1,
  sims = 1,
  type = "lp",
  times = NULL,
  ...
)

\method{predict}{burgle_lm}(
  object,
  newdata,
  original = TRUE,
  draws = 1,
  sims = 1,
  type = "lp",
  se = FALSE,
  limits = NULL,
  ...
)

\method{predict}{burgle_glm}(
  object,
  newdata,
  original = TRUE,
  draws = 1,
  sims = 1,
  type = "lp",
  se = FALSE,
  ...
)
}
\arguments{
\item{object}{the results of burgle_* object}

\item{newdata}{new data of class data.frame}

\item{type}{either 'lp', 'response', 'link' for glm or 'risk' if time dependent}

\item{cause}{which cause do you want to predict}

\item{original}{whether or not to predict using the original model}

\item{draws}{how many different models to simulate}

\item{sims}{how many simulated response to draw}

\item{times}{if type = "risk" time for which to predict risk, if times and sims is multiple the return will be lists within lists}

\item{...}{for future methods}

\item{floor}{will set the minimum odds to 0, if negative odds exists}

\item{seed}{a seed to specificy for simulating responses (multinomial only)}

\item{se}{whether or not to include the standard error in the simulations}

\item{limits}{limits (minimum and maximum) for simulated response values.}
}
\value{
either a matrix or list of new model predictions
}
\description{
Predict for burgle methods
}
