% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loupe.R
\name{loupe}
\alias{loupe}
\title{Loupe: compare new and old data in continuously updated timeseries}
\usage{
loupe(df_current, df_previous, datetime_variable, ...)
}
\arguments{
\item{df_current}{data.frame, the newest/current version of dataset x.}

\item{df_previous}{data.frame, the old version of dataset,
for example x - t1.}

\item{datetime_variable}{string, which variable to use as unique ID to join
\code{df_current} and \code{df_previous}. Usually a "datetime" variable.}

\item{...}{Other \code{waldo::compare()} arguments can be supplied here, such as
\code{tolerance} or \code{max_diffs}. See \code{?waldo::compare()} for a full list.}
}
\value{
A boolean where TRUE indicates no changes to previous data and
FALSE indicates unexpected changes.
}
\description{
A loupe is a simple, small magnification device used to examine small details
more closely.
}
\details{
This function is intended to aid in the verification of continually
updating timeseries data where we expect new values but want to ensure
previous values remains unchanged.

This function matches two dataframe objects by their unique identifier
(usually "time" or "datetime in a timeseries).

It informs the user of new (unmatched) rows which have appeared, and then
returns a \code{waldo::compare()} call to give a detailed breakdown of changes. If
you are not familiar with \code{waldo::compare()}, this is an expanded and more
verbose function similar to base R's \code{all.equal()}.

\code{loupe()} will then return TRUE if there are not changes to previous data,
or FALSE if there are unexpected changes. If you want to extract changes as
a dataframe, use \code{catch()}, or if you want to drop them, use \code{release()}.

The main assumption is that \code{df_current} and \code{df_previous} are a newer and
older versions of the same data, and that the \code{datetime_variable} variable
name always remains the same. Elsewhere new columns can of appear, and these
will be returned in the report.

The underlying functionality is handled by \code{create_object_list()}.
}
\examples{
# Checking two dataframes for changes
# Returning TRUE (no changes) or FALSE (changes)
# This example contains no differences with previous data
butterfly::loupe(
  butterflycount$february, # New or current dataset
  butterflycount$january, # Previous version you are comparing it to
  datetime_variable = "time" # Unique ID variable they have in common
)

# This example does contain differences with previous data
butterfly::loupe(
  butterflycount$march,
  butterflycount$february,
  datetime_variable = "time"
)

}
\seealso{
\code{\link[=create_object_list]{create_object_list()}}
}
