% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_copy.R
\name{ZoteroCopy}
\alias{ZoteroCopy}
\title{Copy collections and items from a Zotero library}
\usage{
ZoteroCopy(
  zotero,
  copy.collections = TRUE,
  copy.items = TRUE,
  copy.extras = TRUE,
  remove.missing = TRUE,
  change.library = FALSE,
  copy.user = TRUE,
  copy.id = NULL,
  copy.api = NULL,
  silent = FALSE
)
}
\arguments{
\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items)}

\item{copy.collections}{Try to copy specified collections, Default: TRUE}

\item{copy.items}{Try to copy specified items?, Default: TRUE}

\item{copy.extras}{Try to copy specified extras (i.e., attachments and
notes)?, Default: TRUE}

\item{remove.missing}{Deleted missing extras, Default: TRUE}

\item{change.library}{Stage changing of library (e.g., from a group to a
personal library), Default: FALSE}

\item{copy.user}{New user type (The functions will use `group` as prefix if
FALSE), Default: TRUE}

\item{copy.id}{New id, Default: NULL}

\item{copy.api}{New API key, Default: NULL}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}
}
\value{
A list with information on the specified Zotero library (e.g., copied
  collections and items)
}
\description{
Replace key identifiers with new ones while keeping existing
  structure and relationship between collections and items
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Fetching collections and items from default group
  zotero = Zotero(
    user = FALSE,
    id = "4827927",
    api = "RqlAmlH5l1KPghfCseAq1sQ1",
    library = TRUE
  )

  # Display collections
  if (any(nrow(zotero$collections))) {
    zotero$collections |>
      dplyr::select(key, version, parentCollection) |>
      print(width = 80)
  }

  # Display items
  if (any(nrow(zotero$items))) {
    zotero$items |>
      dplyr::select(key, version) |>
      print(width = 80)
  }

  # Copy items
  example <- ZoteroCopy(
    zotero,
  )

  # Display collections
  if (any(nrow(example$collections))) {
    example$collections |>
      dplyr::select(key, version, parentCollection) |>
      print(width = 80)
  }

  # Display items
  if (any(nrow(example$items))) {
    example$items |>
      dplyr::select(key, version) |>
      print(width = 80)
  }
}
}
\seealso{
\code{\link[httr]{GET}}
 \code{\link[dplyr]{mutate}}, \code{\link[dplyr]{case_when}},
 \code{\link[dplyr]{filter}}, \code{\link[dplyr]{select}},
 \code{\link[dplyr]{across}}, \code{\link[dplyr]{arrange}}
 \code{\link[purrr]{pmap}}
 \code{\link[tidyselect]{all_of}}
}
