% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_post.R
\name{ZoteroPost}
\alias{ZoteroPost}
\title{Post collections and items to a Zotero library}
\usage{
ZoteroPost(
  zotero,
  post.collections = TRUE,
  post.items = TRUE,
  post.attachments = TRUE,
  post.limit = 50,
  force = FALSE,
  silent = FALSE
)
}
\arguments{
\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items)}

\item{post.collections}{Try to copy specified collections, Default: TRUE}

\item{post.items}{Try to copy specified items?, Default: TRUE}

\item{post.attachments}{Try to copy specified extras (i.e., attachments and
notes)?, Default: TRUE}

\item{post.limit}{Number of collections/items to post per request (max 50),
Default: 50}

\item{force}{Force is seldom wise, but sometimes..., Default: FALSE}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}
}
\value{
A list with information on the specified Zotero library (e.g., posted
  collections and items)
}
\description{
Create or update collections and items in a specified library
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Connect to the public group "c2z_delete"
  # NB! This process can be done using only `Zotero` (see README)
  zotero <- Zotero(
    user = FALSE,
    id = "4988497",
    api = "RqlAmlH5l1KPghfCseAq1sQ1"
  )

  # Create a new collection for POST
  zotero$collections <- tibble::tibble(
    key = ZoteroKey(),
    version = 0,
    name = "Post-test",
    parentCollection = "FALSE"
  )

  # Add item to post using `ZoteroAdd` (and `ZoteroDoi`)
  zotero <- ZoteroAdd(
    zotero,
    doi = "10.1126/sciadv.abd1705"
  )

  # Post a DOI to the public group "c2z_delete"
  example <- ZoteroPost(
    zotero,
    post.collections = TRUE,
    post.items = TRUE
  )

  # Delete collections and items using `ZoteroDelete`
  delete.example <- ZoteroDelete(
    zotero,
    delete.collections = TRUE,
    delete.items = TRUE
  )

  # Print index using `ZoteroIndex`
  if (any(nrow(example$items))) {
    ZoteroIndex(example$items) |>
      dplyr::select(name) |>
      print(width = 80)
  }
}
}
\seealso{
\code{\link[dplyr]{select}}, \code{\link[dplyr]{bind}},
 \code{\link[dplyr]{mutate}}
 \code{\link[httr]{add_headers}}, \code{\link[httr]{RETRY}}
 \code{\link[jsonlite]{toJSON, fromJSON}}
 \code{\link[tibble]{as_tibble}}, \code{\link[tibble]{add_column}}
 \code{\link[utils]{stack}}
 \code{\link[stats]{setNames}}
}
