% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{tickAxis}
\alias{tickAxis}
\title{Axis Tick Options}
\usage{
tickAxis(c3, axis, centered = TRUE, format = NULL, culling = NULL,
  count = NULL, fit = TRUE, values = NULL, rotate = 0,
  outer = TRUE, ...)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{axis}{character 'x', 'y' or 'y2' axis}

\item{centered}{boolean (x-axis only)}

\item{format}{character js function, wrap character or character vector in JS()}

\item{culling}{boolean or list defining number of ticks `list(max = 5)` this
option effects tick labels  (x-axis only)}

\item{count}{integer number of ticks to display. This effects tick lines and labels}

\item{fit}{boolean position ticks evenly or set to values  (x-axis only)}

\item{values}{vector. Must match axis format type}

\item{rotate}{integer degrees to rotate labels  (x-axis only)}

\item{outer}{boolean show axis outer tick}

\item{...}{additional options passed to axis tick object}
}
\value{
c3
}
\description{
Modify axis tick formatting options
}
\examples{
data.frame(a = c(1,2,3,2), b = c(2,4,1,5)) \%>\%
  c3() \%>\%
  tickAxis('y', values = c(1,3))

}
