% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteZeroComponents.R
\name{deleteZeroComponents}
\alias{deleteZeroComponents}
\alias{deleteZeroComponents.lme}
\alias{deleteZeroComponents.merMod}
\title{Delete random effect terms with zero variance}
\usage{
deleteZeroComponents(m)

\method{deleteZeroComponents}{lme}(m)

\method{deleteZeroComponents}{merMod}(m)
}
\arguments{
\item{m}{An object of class \code{\link[lme4]{merMod}} fitted by
\code{\link[lme4]{lmer}} of the lme4-package or of class
\code{\link[nlme]{lme}}.}
}
\value{
An updated object of class \code{\link[lme4]{merMod}}
or of class \code{\link[nlme]{lme}}.

\code{NULL}

\code{NULL}
}
\description{
Is used in the \code{\link{cAIC}} function if \code{method = "steinian"} and
\code{family = "gaussian"}. The function deletes all random effects terms
from the call if corresponding variance parameter is estimated to zero and
updates the model in \code{\link[lme4]{merMod}}.
}
\details{
For \code{\link[lme4]{merMod}} class models:
Uses the \code{cnms} slot of \code{m} and the relative covariance factors to
rewrite the random effects part of the formula, reduced by those parameters
that have an optimum on the boundary. This is necessary to obtain the true
conditional corrected Akaike information. For the theoretical justification
see Greven and Kneib (2010). The reduced model formula is then updated. The
function deleteZeroComponents is then called iteratively to check if in the
updated model there are relative covariance factors parameters on the
boundary.

For \code{\link[nlme]{lme}} class models:
...
}
\section{WARNINGS }{
 For models called via \code{gamm4} or \code{gamm} 
no automated update is available. 
Instead a warning with terms to omit from the model is returned.
}

\examples{

## Currently no data with variance equal to zero...
b <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

deleteZeroComponents(b)
}
\references{
Greven, S. and Kneib T. (2010) On the behaviour of marginal and
conditional AIC in linear mixed models. Biometrika 97(4), 773-789.
}
\seealso{
\code{\link[lme4]{lme4-package}}, \code{\link[lme4]{lmer}},
\code{\link[lme4]{getME}}
}
\author{
Benjamin Saefken, David Ruegamer, Philipp Baumann
}
\keyword{regression}
