% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lenACSStrict.r
\name{lenACSStrict}
\alias{lenACSStrict}
\title{Calculate the length of each common subsequences between a string and a vector/list of strings.
Subsequences cannot be interrupted by any item,
i.e. q-w is not considered a subsequence of q-e-w-r due to the interrupting 'e'}
\usage{
lenACSStrict(vecA, listB, sep = "-", dropFirstItem = FALSE,
  ignoreLenOneSubseq = FALSE)
}
\arguments{
\item{vecA}{The single string}

\item{listB}{The vector/list of 1 or more strings}

\item{sep}{Delimiter separating each items in a sequence}

\item{dropFirstItem}{Boolean. If true, the first item in each sequence is excluded from counting all subsequences}

\item{ignoreLenOneSubseq}{Boolean. If true, all length one subequences are not counted as common subsequences}
}
\value{
A list of vectors of the length of each common subsequence
}
\description{
Calculate the length of each common subsequences between a string and a vector/list of strings.
Subsequences cannot be interrupted by any item,
i.e. q-w is not considered a subsequence of q-e-w-r due to the interrupting 'e'
}
\examples{
lenACSStrict("q-w-e-r", c("q-e-w-r","q-r-e-w","q-w-r-e"), "-")
lenACSStrict("itemToBeDropped-q-w-e-r", "itemToBeDroped-q-e-w-r", "-", dropFirstItem=TRUE)

}

