% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tps0}
\alias{tps0}
\title{Predicted transition probabilities out of transplant state made at time s = 0}
\format{
\subsection{'tps0'}{

A data frame with 13,674 (CHANGE) rows and 14 columns:
\describe{
\item{id}{Patient indentifier}
\item{pstate1, pstate2, pstate3, pstate4, pstate5, pstate6}{Predicted transition probabilities of transitions into states 1 to 6}
\item{se1, se2, se3, se4, se5, se6}{Standard error of the predicted transition probabilities of transitions into states 1 to 6}
\item{j}{State from which the predicted transition probabilities are estimated from}
}
}
}
\source{
This dataset was derived from data made available within the \code{mstate} package, see \code{\link[mstate]{ebmt4}}.
The data was originally provided by the European Group for Blood and Marrow Transplantation (https://www.ebmt.org/).
We reiterate the source statement given by the developers of \code{mstate}:
"We acknowledge the European Society for Blood and Marrow Transplantation (EBMT)
for making available these data. Disclaimer: these data were simplified for the
purpose of illustration of the analysis of competing risks and multi-state models
and do not reflect any real life situation. No clinical conclusions should be
drawn from these data."
}
\usage{
tps0
}
\description{
Data frame containing the predicted transition probabilities out of state j = 1
made at time s = 0. The predicted transition probabilities were estimated by fitting
a multistate model to the \code{\link[mstate]{ebmt4}} data using a leave-one-out approach.
Code for deriving this dataset is provided in the source code for \code{calibmsm}. Code for the derivation
of this dataset is provided in the source code for the package.
}
\references{
EBMT (2023). “Data from the European Society for Blood and Marrow Transplantation.”
URL https://search.r-project.org/CRAN/refmans/mstate/html/EBMT-data.html.

de Wreede LC, Fiocco M, Putter H (2011). “mstate: An R Package for the Analysis of
Competing Risks and Multi-State Models.” \emph{Journal of Statistical Software}, 38(7).
}
\keyword{datasets}
