#'
#' Prints the regression table of a component model
#'
#' @param object a list with class \code{"callback_reg"}.
#' @param ... further arguments passed to or from other methods.
#'
#' @return Printed output.
#'
#' @author Emmanuel Duguet
#'
#' @examples
#' model <- list(c("license"),c("woman"),c("woman","license","inter"))
#' comp <- callback_comp(data = mobility1, cluster = "offer", 
#' candid = c("gender","licenses"), callback = "callback", model = model)
#' z <- reg(comp)
#' summary(z)
#'
#' @export

summary.callback_reg <- function(object, ...) {
  cat("\n",
      "Component model estimation:\n",
      "\n")
  m <- cbind(object$reg$estim[,c("coef","std_coef","student","p_value")],
              stat_signif(object$reg$estim$p_value))
  rownames(m) <- object$reg$estim$c_names
  colnames(m) <- c("Estimate","Std. Error","t value","Pr(>|t|)","")
  print(m)
  cat("\n Signif. codes: 0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.10 ' ' 1\n")
  r <- object$reg$over_test
  if (is.null(r)==TRUE) {cat("\n","Overidentification test not available with OLS.")
  } else {
      if (r$df == 0){cat("\n","Model just identified.")
      } else {
        cat("\n","Overidentification test:\n")
        print(as.data.frame(r),row.names=FALSE)}
    }
}