% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_time.R
\name{shift_time}
\alias{shift_time}
\title{Shift date-times}
\usage{
shift_time(x, deployment_id, duration)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{deployment_id}{One or more deploymentIDs.}

\item{duration}{Difference between the current and new date-times.
Provide as a \code{\link[lubridate:duration]{lubridate::duration()}} or \link{difftime}.}
}
\value{
\code{x} with shifted date-times.
}
\description{
Shifts date-times for selected deployments (and associated media and
observations) by a specified duration.
This function can be used to correct date-time issues such as incorrectly
set time zones.
\itemize{
\item Deployments: \code{deploymentStart} and \code{deploymentEnd} are updated and
\code{timestampIssues} is set to \code{FALSE}.
\item Media: \code{timestamp} is updated.
\item Observations: \code{eventStart} and \code{eventEnd} are updated.
\item Metadata (\code{x$temporal}) are updated to match the new temporal scope.
}
}
\examples{
# Set desired duration between current and new date-times (e.g. 4 hours earlier)
library(lubridate, warn.conflicts = FALSE)
duration(-4, units = "hours")

# Or calculate one based on two date-times
current <- ymd_hms("2024-04-01T04:00:00", tz = "UTC")
new <- ymd_hms("2024-04-01T00:00:00", tz = "UTC")
duration <- as.duration(interval(current, new))

# Shift date-times for 2 deployments
x <- example_dataset()
x_shifted <- shift_time(x, c("00a2c20d", "29b7d356"), duration)

# Inspect results
deployments(x)[, c("deploymentID", "deploymentStart", "deploymentEnd")]
deployments(x_shifted)[, c("deploymentID", "deploymentStart", "deploymentEnd")]
}
\seealso{
Other transformation functions: 
\code{\link{merge_camtrapdp}()},
\code{\link{round_coordinates}()},
\code{\link{update_taxon}()},
\code{\link{write_dwc}()},
\code{\link{write_eml}()}
}
\concept{transformation functions}
