% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agricultural_divisions.R
\name{get_agricultural_divisions}
\alias{get_agricultural_divisions}
\title{Canadian Map at Census Agricultural Region (CAR) Level}
\usage{
get_agricultural_divisions(map = census_divisions)
}
\arguments{
\item{map}{which map to add, by default it takes the complete Census
Divisions (CD) map}
}
\value{
a tibble with economic regions, provinces and geometry
(multipolygon) fields.
}
\description{
This function aggregates the Census Divisions (CD) map
to provide the Census Agricultural Region (CAR) map. The idea is to avoid
providing a dataset with map that can be obtained as an aggregation of
another.
}
\examples{
get_agricultural_divisions(
 census_divisions[census_divisions$prname == "Ontario",]
)
}
