% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{phylocom}
\alias{phylocom}
\title{Phylocom example data}
\format{
A list with three elements:
\describe{
\item{phylo}{Phylogeny with 32 tips}
\item{sample}{Community matrix with 6 sites (rows) and 25 species
(columns).}
\item{traits}{Trait data; a data.frame with 32 species (rows) and 4 traits
(columns)}
}
}
\usage{
phylocom
}
\description{
Fictional data for testing purposes from
\href{https://www.phylodiversity.net/phylocom/}{Phylocom} (Webb et al. 2008)
}
\details{
Obtained via the \code{picante} package (Kembel et al. 2010)
}
\examples{
# Example phylogeny
phylocom$phy
# Example community
phylocom$comm
}
\references{
Webb, C.O., Ackerly, D.D., and Kembel, S.W. 2008. Phylocom:
software for the analysis of phylogenetic community structure and trait
evolution. Version 4.0.1. http://www.phylodiversity.net/phylocom/.

Kembel, et al. Picante: R tools for integrating phylogenies and
ecology, Bioinformatics 26: 1463–1464 \doi{10.1093/bioinformatics/btq166}
}
\keyword{datasets}
