% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_metadata.R
\name{get_cansim_table_template}
\alias{get_cansim_table_template}
\title{Retrieve table template from Statistics Canada API}
\usage{
get_cansim_table_template(
  cansimTableNumber,
  language = "english",
  refresh = FALSE
)
}
\arguments{
\item{cansimTableNumber}{A new or old CANSIM/NDM table number or a vector of table numbers}

\item{language}{Language for the dimension and member names, either "eng" or "fra"}

\item{refresh}{Refresh the data from the Statistics Canada API}
}
\value{
a tibble containing the table template
}
\description{
A table template consists of the dimensions and members and coordinates of a table that can be used to explore
and filter table data before downloading subsets of the table. To add vector Ids to (a possibly filtered) template
the `add_cansim_vectors_to_template` function can be used.
}
\examples{
\dontrun{
get_cansim_table_template("34-10-0013")
}
}
