% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{validate_domain_score}
\alias{validate_domain_score}
\title{Check whether a CAPL-2 domain score is valid.}
\usage{
validate_domain_score(x = NA, domain = NA)
}
\arguments{
\item{x}{A vector representing a CAPL domain score.}

\item{domain}{A character vector representing domains within CAPL (valid values are "pc", "db", "mc", "ku"; valid values are not
case-sensitive).}
}
\value{
Returns a numeric vector (if valid) or NA (if not valid).
}
\description{
This function checks whether a CAPL-2 domain score is numeric and within a valid range.
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_number]{validate_number()}} and \code{\link[=validate_integer]{validate_integer()}}.
}
\examples{
validate_domain_score(
  x = c(34, 15, 10, 12.5, 25),
  domain = "pc"
)

# [1]   NA 15.0 10.0 12.5 25.0

}
