% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{CARAEE_Alloc}
\alias{CARAEE_Alloc}
\title{Allocation Function of CARA Designs Based on Efficiency and Ethics for Binary and Continuous Response.}
\usage{
CARAEE_Alloc(ptsb.cov, ptsb.t, ptsb.Y, ptnow.cov, gamma, response)
}
\arguments{
\item{ptsb.cov}{a \code{n x k} covariate matrix of previous patients.}

\item{ptsb.t}{a treatment vector of previous patients with length \code{n}.}

\item{ptsb.Y}{a response vector of previous patients with length \code{n}.}

\item{ptnow.cov}{a covariate vector of the incoming patient with length \code{k}.}

\item{gamma}{a non-negative number. A tuning parameter that reflects the importance of the efficiency component compared to the ethics component.}

\item{response}{the type of the response. Options are \code{"Binary"} or \code{"Cont"}.}
}
\value{
\item{prob}{Probability of assigning the upcoming patient to treatment A for binary and continuous response.}
}
\description{
Calculating the probability of assigning the upcoming patient to treatment A based on the patient's covariates and the previous patients' covariates and responses for CARAEE procedure.
}
\details{
Covariate-Adjusted Response-Adaptive with Ethics and Efficiency (CARAEE) Design:
The CARAEE procedure balances both ethical considerations and statistical efficiency when assigning subjects to treatments.

As a start-up rule, \eqn{m_0} subjects are assigned to each treatment using a balanced randomization scheme.

Assume that \eqn{m \geq 2m_0} subjects have been assigned, and their responses \eqn{\{\boldsymbol{X}_i, i = 1, \ldots, m\}} and covariates \eqn{\{\boldsymbol{Z}_i, i = 1, \ldots, m\}} are observed. Let \eqn{\hat{\boldsymbol{\theta}}(m) = \left( \hat{\theta}_1(m), \hat{\theta}_2(m) \right)}, where \eqn{\hat{\theta}_k(m)} is the maximum likelihood estimate of the treatment-specific parameter \eqn{\theta_k} based on the data for treatment group \eqn{k}.

For the incoming subject \eqn{(m+1)} with covariates \eqn{\boldsymbol{Z}_{m+1}}, we define the efficiency and ethics measures for each treatment as:
\eqn{
\boldsymbol{d}(\boldsymbol{Z}, \boldsymbol{\theta}) = \left(d_1(\boldsymbol{Z}, \theta), d_2(\boldsymbol{Z}, \theta)\right), \quad
\boldsymbol{e}(\boldsymbol{Z}, \boldsymbol{\theta}) = \left(e_1(\boldsymbol{Z}, \theta), e_2(\boldsymbol{Z}, \theta)\right).
}

The allocation probability of assigning subject \eqn{(m+1)} to treatment 1 is given by:
\deqn{
\phi_{m+1}(\boldsymbol{Z}_{m+1}, \hat{\boldsymbol{\theta}}(m)) =
\frac{e_1(\boldsymbol{Z}_{m+1}, \hat{\boldsymbol{\theta}}(m)) \cdot d_1^\gamma(\boldsymbol{Z}_{m+1}, \hat{\boldsymbol{\theta}}(m))}
{e_1(\boldsymbol{Z}_{m+1}, \hat{\boldsymbol{\theta}}(m)) \cdot d_1^\gamma(\boldsymbol{Z}_{m+1}, \hat{\boldsymbol{\theta}}(m)) + e_2(\boldsymbol{Z}_{m+1}, \hat{\boldsymbol{\theta}}(m)) \cdot d_2^\gamma(\boldsymbol{Z}_{m+1}, \hat{\boldsymbol{\theta}}(m))}.
}

This allocation rule is scale-invariant in both efficiency and ethics components due to its ratio-based form. The tuning parameter \eqn{\gamma \geq 0} controls the trade-off between the two: when \eqn{\gamma = 0}, the assignment is based purely on ethical considerations; larger values of \eqn{\gamma} increase the emphasis on statistical efficiency. More details can be found in Hu, Zhu & Zhang(2015).
}
\examples{
set.seed(123)

n_prev = 40
covariates = cbind(Z1 = rnorm(n_prev), Z2 = rnorm(n_prev))
treatment = sample(c(0, 1), n_prev, replace = TRUE)
response = rbinom(n_prev, size = 1, prob = 0.6)

# Simulate new incoming patient
new_patient_cov = c(Z1 = rnorm(1), Z2 = rnorm(1))

# Run allocation function
result = CARAEE_Alloc(
 ptsb.cov = covariates,
 ptsb.t = treatment,
 ptsb.Y = response,
 ptnow.cov = new_patient_cov,
 response = "Binary",
 gamma=1
)
print(result$prob)

}
\references{
Hu, J., Zhu, H., & Hu, F. (2015). A unified family of covariate-adjusted response-adaptive designs based on efficiency and ethics.
\emph{Journal of the American Statistical Association}, 110(509), 357–367.
}
\concept{CARAEE Design}
