% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_models.R
\name{survival_weibull}
\alias{survival_weibull}
\title{Weibull-Based Estimates of Stand Survival}
\usage{
survival_weibull(t, alpha, s_100)
}
\arguments{
\item{t}{Time in years after stand establishment}

\item{alpha}{Shape parameter. According to Staupendahl, Values < 1 indicate a
high risk at young ages, alpha = 1 indicates an indifference of the risk to
t (exponential distribution), values > 1 indicate high risk at old ages,
where 1 < alpha < 2 means a degressively increasing, alpha = 2 a constantly
increasing, and alpha > 2 a progressively increasing risk.}

\item{s_100}{Survival probability up to t = 100}
}
\value{
The probability to survive up to t = 100
}
\description{
Estimates the probability of a forest stand to survive a period t after its
establishment, based on the Weibull-Method published by Staupendahl (2011)
Forstarchiv 82, 10-19.
}
\details{
The parameter \code{s_100} represents the survival probability after t = 100
years, and \code{alpha} is the shape parameter, indicating the risk profile
of the stand (type) of interest.
}
\examples{
  # Calculations for Common oak, European beech, Norway spruce, Douglas fir,
  # and Scots pine with parameters after Staupendahl and Zucchini (AFJZ 2011)
  t <- seq(0, 120, 5)
  survival_weibull(t, alpha = 2.75, s_100 = 0.971) # oak
  survival_weibull(t, alpha = 1.76, s_100 = 0.967) # beech
  survival_weibull(t, alpha = 2.78, s_100 = 0.726) # spruce
  survival_weibull(t, alpha = 3.11, s_100 = 0.916) # Douglas
  survival_weibull(t, alpha = 2.45, s_100 = 0.923) # pine


}
