% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_var_imp}
\alias{get_var_imp}
\title{Variable importance for forecasting model.}
\usage{
get_var_imp(object, plot = TRUE)
}
\arguments{
\item{object}{A list class of ARml or forecast object derived from ARml}

\item{plot}{Boolean, if TRUE, variable importance will be ploted.}
}
\value{
A list class of "varImp.train". See \code{\link[caret]{varImp}} or a
"trellis" plot.
}
\description{
Variable importance for forecasting model.
}
\examples{

train <- window(AirPassengers, end = c(1959, 12))

test <- window(AirPassengers, start = c(1960, 1))

ARml(train, caret_method = "lm", max_lag = 12, trend_method = "none",
 pre_process = "center") -> fit

forecast(fit, h = length(test), level = c(80,95)) -> fc

autoplot(fc)+ autolayer(test)

accuracy(fc, test)

get_var_imp(fc, plot = TRUE)


}
\author{
Resul Akay
}
