% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoabsences.R
\name{pseudoabsences}
\alias{pseudoabsences}
\alias{n_pseudoabsences}
\alias{pseudoabsence_method}
\alias{pseudoabsence_data}
\title{Obtain Pseudoabsences}
\usage{
pseudoabsences(occ,
               pred = NULL,
               method = "random",
               n_set = 10,
               n_pa = NULL,
               variables_selected = NULL,
               th = 0,
               size = 1,
               crs = 4326)

n_pseudoabsences(i)

pseudoabsence_method(i)

pseudoabsence_data(i)
}
\arguments{
\item{occ}{A \code{occurrences_sdm} or \code{input_sdm} object.}

\item{pred}{A \code{sdm_area} object. If \code{NULL} and \code{occ} is a \code{input_sdm},
\code{pred} will be retrieved from \code{occ}.}

\item{method}{Method to create pseudoabsences. One of: "random", "bioclim", "mahal.dist" or
"buffer_sdm".}

\item{n_set}{\code{numeric}. Number of datasets of pseudoabsence to create.}

\item{n_pa}{\code{numeric}. Number of pseudoabsences to be generated in each dataset created.
If \code{NULL} then the function prevents imbalance by using the same number of presence records
(\code{n_records(occ)}). If you want to address different sizes to each species, you must provide
a named vector (as in \code{n_records(occ)}).}

\item{variables_selected}{A vector with variables names to be used while building pseudoabsences.
Only used when method is not "random".}

\item{th}{\code{numeric} Threshold to be applied in bioclim/mahal.dist projections. See details.}

\item{size}{\code{numeric} The distance between the record and the margin of the buffer (i.e.
buffer radius).}

\item{crs}{\code{numeric} Indicates which EPSG it the size in.}

\item{i}{A \code{input_sdm} object.}
}
\value{
A \code{occurrences_sdm} or \code{input_sdm} object with pseudoabsence data.
}
\description{
This function obtains pseudoabsences given a set of predictors.
}
\details{
\code{pseudoabsences} is used in the SDM workflow to obtain pseudoabsences, a step necessary for
most of the algorithms to run. We implemented three methods so far: \code{"random"}, which is
self-explanatory, \code{"bioclim"}, \code{"mahal.dist"} and \code{"buffer_sdm"}. The two last are
built with the idea that pseudoabsences should be environmentally different from presences. Thus,
we implemented two presence-only methods to infer the distribution of the species. \code{"bioclim"} uses an
envelope approach (bioclimatic envelope), while \code{"mahal.dist"} uses a distance approach
(mahalanobis distance). \code{th} parameter enters here as a threshold to binarize those results.
Pseudoabsences are retrieved outside the projected distribution of the species.

\code{n_pseudoabsences} returns the number of pseudoabsences obtained per species.

\code{pseudoabsence_method} returns the method used to obtain pseudoabsences.

\code{pseudoabsence_data} returns a \code{list} of species names. Each species name will have a
\code{list}s with pseudoabsences data from class \code{sf}.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 25000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio4", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="random")

}
\seealso{
\code{link{input_sdm} \link{sdm_area} \link{occurrences_sdm}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
