% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{display}
\alias{display}
\title{Display}
\usage{
display(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A character string specifying a display type. One of,
\itemize{
\item \code{"none"}
\item \code{"inline"}
\item \code{"inline-block"}
\item \code{"block"}
\item \code{"grid"}
\item \code{"inline-grid"}
\item \code{"table"}
\item \code{"table-cell"}
\item \code{"table-row"}
\item \code{"flex"}
\item \code{"inline-flex"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{display()} function adjusts how a tag element and its contents are
rendered.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    display("flex") \%>\%
    flex_justify("center"),
  "Powerful stuff"
)

div(
  .style \%>\%
    display(
      xs = "inline",
      md = "block"
    ),
  "Block and roll"
)

}
