% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rounded-all.R
\name{rounded_all}
\alias{rounded_all}
\alias{rounded_top}
\alias{rounded_right}
\alias{rounded_bottom}
\alias{rounded_left}
\title{Element corners}
\usage{
rounded_all(x, size)

rounded_top(x, size)

rounded_right(x, size)

rounded_bottom(x, size)

rounded_left(x, size)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{size}{A number or character string specifying a corner size. One of,
\itemize{
\item \code{0}
\item \code{1}
\item \code{2}
\item \code{3}
\item \code{4}
\item \code{5}
\item \code{"circle"}
\item \code{"pill"}

Use \code{0} to remove rounded corners.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \verb{rounded_*()} functions adjust the corners of a tag element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    rounded_all(3)
)

div(
  .style \%>\%
    rounded_left("pill")
)

}
