% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Type.R
\docType{class}
\name{ClaimType-class}
\alias{ClaimType-class}
\title{An S4 class to represent a claim type.}
\description{
An S4 class to represent a claim type.
}
\section{Slots}{

\describe{
\item{\code{simno}}{The simulation index.}

\item{\code{line}}{A string to identify the business line that the claim belongs to.}

\item{\code{claimType}}{A string to identify the type of the claim. It further classifies the claims within a business line. For example, the type could be based on the size of the loss.}

\item{\code{iRBNER}}{A Boolean variable to indicate whether RBNER (open claims) should be simulated.}

\item{\code{iROPEN}}{A Boolean variable to indicate whether claim reopen should be simulated.}

\item{\code{iIBNR}}{A Boolean variable to indicate whether IBNR claims should be simulated.}

\item{\code{iUPR}}{A Boolean variable to indicate whether future claims should be simulated.}

\item{\code{fIBNER}}{IBNER development factor.}

\item{\code{severity}}{Severity distribution.}

\item{\code{frequency}}{Frequency distribution.}

\item{\code{reportLag}}{Report lag distribution.}

\item{\code{settlementLag}}{Settlement lag distribution.}

\item{\code{reopen}}{Claim reopen probability based on the number of years after settlement till valuation date.}

\item{\code{reopenLag}}{Reopen lag distribution.}

\item{\code{resettleLag}}{Resettlement lag distribution.}

\item{\code{roDevFac}}{Reopened claim development factor.}

\item{\code{ioDevFac}}{A numeric variable to indicate the method of loss development for open claim severity. 1: Conditional distribution based on paid loss; 2: conditional distribution based on incurred loss; 3: year-to-year development factors}

\item{\code{irDevFac}}{A numeric variable to indicate the method of loss development for claim reopen severity simulation. 1: Conditional distribution based on paid loss; 2: conditional distribution based on incurred loss; 3: year-to-year development factors}

\item{\code{freqIndex}}{Frequency distribution time index.}

\item{\code{severityIndex}}{Severity distribution time index.}

\item{\code{exposureIndex}}{Exposure time index for IBNR or UPR.}

\item{\code{iCopula}}{Whether copula is used to model severity, report lag and settlement lag.}

\item{\code{ssrCopula}}{Copula object used for severity, report lag and settlement lag.}

\item{\code{sdata}}{Indicating whether only closed claims (CLOSED) or closed + open claims (ALL) will be used for severity fitting.}

\item{\code{p0}}{An yearly table that controls the probability of invalid claim, excluding these valid claims less than deductible based on development year. It is based on the DevFac class.}
}}

