% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{mpareto}
\alias{mpareto}
\alias{dpareto}
\alias{ppareto}
\alias{qpareto}
\alias{rpareto}
\title{Moment function of Pareto Distribution (PDF: alpha*xm^alpha/x^(alpha+1))}
\usage{
mpareto(order, xm, alpha = 3)

dpareto(x, xm, alpha = 3)

ppareto(q, xm, alpha = 3)

qpareto(p, xm, alpha = 3)

rpareto(n, xm, alpha = 3)
}
\arguments{
\item{order}{Order of moment}

\item{xm}{Threshold value}

\item{alpha}{Default=3}

\item{x}{Value of the variable}

\item{q}{Value of the variable}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Moment function of Pareto Distribution (PDF: alpha*xm^alpha/x^(alpha+1))

Density function of Pareto Distribution (PDF: alpha*xm^alpha/x^(alpha+1))

Cumulative probability function of Pareto Distribution (CDF: 1-(xm/x)^alpha)

Quantile function of Pareto Distribution

Random generation of Pareto Distribution
}
\examples{
mpareto(1,1000,2)
dpareto(1500,1000,2)
ppareto(1500,1000,2)
qpareto(0.5,1000,2)
rpareto(100,1000,2)
}
