% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A.R, R/Copula.R, R/FitDist.R
\docType{methods}
\name{setObservation<-}
\alias{setObservation<-}
\alias{setObservation<-,CopulaObj,matrix-method}
\alias{setObservation,ANY-method}
\alias{setObservation<-,FitDist,matrix-method}
\title{Input the raw data.}
\usage{
setObservation(this) <- value

\S4method{setObservation}{CopulaObj,matrix}(this) <- value

\S4method{setObservation}{FitDist,matrix}(this) <- value
}
\arguments{
\item{this}{FitDist Object or Copula Object}

\item{value}{A data frame or a matrix. For FitDist object, it could be a two-column data frame with the occurrence date and loss size/number of occurrence. Or a one-column data frame with loss size (ifreq == FALSE) or number of occurrence (ifreq == TRUE && idate == FALSE) or occurrence dates (ifreq == TRUE && idate == TRUE). For Copula object, it could be a matrix with each column contains the experience data of a variable.}
}
\description{
Input the raw data.
}
\examples{
library(cascsim)
dist1<-new("Pareto",p1=20,p2=3)
dist2<-new("Normal",p1=5,p2=3,min=0,max=20,truncated=TRUE)
nom.cop <- new("CopulaObj", param=c(0.5),marginal=list(dist1=dist1,dist2=dist2),dimension=2)
setObservation(nom.cop)<-copulaSample(nom.cop,100)
nom.cop@observation
}
