% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{sc_monotonic}
\alias{sc_monotonic}
\title{Measure of Spearman Correlation}
\usage{
sc_monotonic(x, y)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector}
}
\value{
A "numeric" object that gives the plot's monotonic score.
}
\description{
Measure of Spearman Correlation
}
\examples{
  require(ggplot2)
  require(tidyr)
  require(dplyr)
  data(anscombe)
  anscombe_tidy <- anscombe \%>\%
  pivot_longer(cols = everything(),
    names_to = c(".value", "set"),
    names_pattern = "(.)(.)")
  ggplot(anscombe_tidy, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~set, ncol=2, scales = "free")
  sc_monotonic(anscombe$x1, anscombe$y1)
  sc_monotonic(anscombe$x2, anscombe$y2)
  sc_monotonic(anscombe$x3, anscombe$y3)
  sc_monotonic(anscombe$x4, anscombe$y4)

}
