% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{top_scags}
\alias{top_scags}
\title{Calculate the top pair of variables or group for each scagnostic}
\usage{
top_scags(scags_data)
}
\arguments{
\item{scags_data}{A dataset of scagnostic values that was returned by calc_scags or calc_scags_wide}
}
\value{
A data frame where each row is a scagnostic with its highest pair and the associated value
}
\description{
Calculate the top pair of variables or group for each scagnostic
}
\examples{
#an example using calc_scags
require(dplyr)
datasaurus_dozen \%>\%
  group_by(dataset) \%>\%
  summarise(calc_scags(x,y, scags=c("monotonic", "outlying", "convex"))) \%>\%
  top_scags()
 #an example using calc_scags_wide
 data(pk)
 scags_data <- calc_scags_wide(pk[,2:5], scags=c("outlying","clumpy","monotonic"))
 top_scags(scags_data)
}
\seealso{
calc_scags calc_scags_wide top_pairs
}
