% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_cox_tune.R
\name{cat_cox_tune}
\alias{cat_cox_tune}
\title{Catalytic Cox Proportional-Hazards Model (COX) Fitting Function by Tuning tau from a Sequence of tau Values}
\usage{
cat_cox_tune(
  formula,
  cat_init,
  method = c("CRE", "WME"),
  tau_seq = NULL,
  cross_validation_fold_num = 5,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the Cox model. Should at least include response variables (e.g. \code{~.}).}

\item{cat_init}{A list generated from \code{cat_cox_initialization}.}

\item{method}{The estimation method, either \code{"CRE"} (Catalytic-regularized Estimator) or \code{"WME"} (Weighted Mixture Estimator).}

\item{tau_seq}{A numeric vector specifying the sequence of \code{tau} values to be tested.
If NULL, a default sequence is generated based on the number of predictors.}

\item{cross_validation_fold_num}{An integer representing the number of folds for cross-validation.
Defaults to 5.}

\item{...}{Additional arguments passed to the \code{cat_cox} function for model fitting.}
}
\value{
A list containing the values of all the arguments and the following components:
\item{tau}{he optimal \code{tau} value determined from cross-validation.}
\item{model}{The fitted lmer model object by using the optimal \code{tau} value.}
\item{coefficients}{Coefficients of the fitted model by using the optimal \code{tau} value.}
\item{likelihood_list}{Average likelihood value for each \code{tau }value.}
}
\description{
This function tunes a catalytic Cox proportional-hazards model (COX) by performing cross-validation
to estimate the optimal value of the tuning parameter \code{tau}. It finally uses the optimal tau value
in the \code{cat_cox} function for model fitting.
}
\examples{
library(survival)
data("cancer")
cancer$status[cancer$status == 1] <- 0
cancer$status[cancer$status == 2] <- 1

cat_init <- cat_cox_initialization(
  formula = Surv(time, status) ~ 1, # formula for simple model
  data = cancer,
  syn_size = 100, # Synthetic data size
  hazard_constant = 0.1, # Hazard rate value
  entry_points = rep(0, nrow(cancer)), # Entry points of each observation
  x_degree = rep(1, ncol(cancer) - 2), # Degrees for polynomial expansion of predictors
  resample_only = FALSE, # Whether to perform resampling only
  na_replace = stats::na.omit # How to handle NA values in data
)

cat_model <- cat_cox_tune(
  formula = ~., # Should at least include response variables
  cat_init = cat_init, # Only accept object generated from `cat_cox_initialization`
  tau_seq = c(1, 2), # Vector of weights for synthetic data
  cross_validation_fold_num = 5 # number of folds for cross-validation
)
cat_model
}
